/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.npm.internal;

import com.google.common.base.Preconditions;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.repository.IllegalOperationException;
import org.sonatype.nexus.repository.InvalidContentException;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.npm.internal.NpmHostedFacet;
import org.sonatype.nexus.repository.npm.internal.NpmPackageId;
import org.sonatype.nexus.repository.npm.internal.NpmResponses;
import org.sonatype.nexus.repository.npm.internal.NpmTokenFacet;
import org.sonatype.nexus.repository.npm.internal.search.legacy.NpmSearchIndexFacet;
import org.sonatype.nexus.repository.npm.internal.search.v1.NpmSearchFacet;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Parameters;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;

public final class NpmHandlers {
    private static final Logger log = LoggerFactory.getLogger(NpmHandlers.class);
    static final String T_PACKAGE_NAME = "packageName";
    static final String T_PACKAGE_VERSION = "packageVersion";
    static final String T_PACKAGE_SCOPE = "packageScope";
    static final String T_REVISION = "revision";
    static final String T_TARBALL_NAME = "tarballName";
    static final String T_USERNAME = "userName";
    static final String USER_LOGIN_PREFIX = "/-/user/org.couchdb.user:";
    static final String T_TOKEN = "token";
    static Handler npmErrorHandler = new Handler(){

        @Nonnull
        public Response handle(@Nonnull Context context) throws Exception {
            try {
                return context.proceed();
            }
            catch (IllegalArgumentException | IllegalOperationException e) {
                Response error = NpmResponses.badRequest(e.getMessage());
                log.warn("Error: {} {}: {} - {}", new Object[]{context.getRequest().getAction(), context.getRequest().getPath(), error.getStatus(), e.getMessage(), e});
                return error;
            }
            catch (InvalidContentException e) {
                Response error = "PUT".equals(context.getRequest().getAction()) ? NpmResponses.badRequest(e.getMessage()) : NpmResponses.notFound(e.getMessage());
                log.warn("Error: {} {}: {} - {}", new Object[]{context.getRequest().getAction(), context.getRequest().getPath(), error.getStatus(), e.getMessage(), e});
                return error;
            }
        }
    };
    static Handler getPackage = new Handler(){

        @Nonnull
        public Response handle(@Nonnull Context context) throws Exception {
            TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
            Repository repository = context.getRepository();
            log.debug("[getPackage] repository: {} tokens: {}", (Object)repository.getName(), (Object)state.getTokens());
            NpmPackageId packageId = NpmHandlers.packageId(state);
            Content content = ((NpmHostedFacet)repository.facet(NpmHostedFacet.class)).getPackage(packageId);
            if (content != null) {
                return NpmResponses.ok((Payload)content);
            }
            return NpmResponses.packageNotFound(packageId);
        }
    };
    static Handler putPackage = new Handler(){

        @Nonnull
        public Response handle(@Nonnull Context context) throws Exception {
            TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
            Repository repository = context.getRepository();
            log.debug("[putPackage] repository: {} tokens: {}", (Object)repository.getName(), (Object)state.getTokens());
            ((NpmHostedFacet)repository.facet(NpmHostedFacet.class)).putPackage(NpmHandlers.packageId(state), NpmHandlers.revision(state), context.getRequest().getPayload());
            return NpmResponses.ok();
        }
    };
    static Handler deletePackage = new Handler(){

        @Nonnull
        public Response handle(@Nonnull Context context) throws Exception {
            TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
            Repository repository = context.getRepository();
            log.debug("[deletePackage] repository: {} tokens: {}", (Object)repository.getName(), (Object)state.getTokens());
            NpmPackageId packageId = NpmHandlers.packageId(state);
            Set<String> deleted = ((NpmHostedFacet)repository.facet(NpmHostedFacet.class)).deletePackage(packageId, NpmHandlers.revision(state));
            if (!deleted.isEmpty()) {
                return NpmResponses.ok();
            }
            return NpmResponses.packageNotFound(packageId);
        }
    };
    static Handler getTarball = new Handler(){

        @Nonnull
        public Response handle(@Nonnull Context context) throws Exception {
            TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
            Repository repository = context.getRepository();
            log.debug("[getTarball] repository: {} tokens: {}", (Object)repository.getName(), (Object)state.getTokens());
            NpmPackageId packageId = NpmHandlers.packageId(state);
            String tarballName = NpmHandlers.tarballName(state);
            Content content = ((NpmHostedFacet)repository.facet(NpmHostedFacet.class)).getTarball(packageId, tarballName);
            if (content != null) {
                return NpmResponses.ok((Payload)content);
            }
            return NpmResponses.tarballNotFound(packageId, tarballName);
        }
    };
    static Handler deleteTarball = new Handler(){

        @Nonnull
        public Response handle(@Nonnull Context context) throws Exception {
            TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
            Repository repository = context.getRepository();
            log.debug("[deleteTarball] repository: {} tokens: {}", (Object)repository.getName(), (Object)state.getTokens());
            NpmPackageId packageId = NpmHandlers.packageId(state);
            String tarballName = NpmHandlers.tarballName(state);
            Set<String> deleted = ((NpmHostedFacet)repository.facet(NpmHostedFacet.class)).deleteTarball(packageId, tarballName);
            if (!deleted.isEmpty()) {
                return NpmResponses.ok();
            }
            return NpmResponses.tarballNotFound(packageId, tarballName);
        }
    };
    @Deprecated
    static Handler searchIndex = new Handler(){

        @Nonnull
        public Response handle(@Nonnull Context context) throws Exception {
            Repository repository = context.getRepository();
            Parameters parameters = context.getRequest().getParameters();
            log.debug("[searchIndex] repository: {} parameters: {}", (Object)repository.getName(), (Object)parameters);
            return NpmResponses.ok((Payload)((NpmSearchIndexFacet)repository.facet(NpmSearchIndexFacet.class)).searchIndex(NpmHandlers.indexSince(parameters)));
        }
    };
    static Handler searchV1 = new Handler(){

        @Nonnull
        public Response handle(@Nonnull Context context) throws Exception {
            Repository repository = context.getRepository();
            Parameters parameters = context.getRequest().getParameters();
            log.debug("[searchV1] repository: {} parameters: {}", (Object)repository.getName(), (Object)parameters);
            return NpmResponses.ok((Payload)((NpmSearchFacet)repository.facet(NpmSearchFacet.class)).searchV1(parameters));
        }
    };
    static Handler createToken = new Handler(){

        @Nonnull
        public Response handle(@Nonnull Context context) throws Exception {
            TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
            Repository repository = context.getRepository();
            log.debug("[createToken] repository: {} tokens: {}", (Object)repository.getName(), (Object)state.getTokens());
            return ((NpmTokenFacet)repository.facet(NpmTokenFacet.class)).login(context);
        }
    };
    static Handler deleteToken = new Handler(){

        @Nonnull
        public Response handle(@Nonnull Context context) throws Exception {
            TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
            Repository repository = context.getRepository();
            log.debug("[deleteToken] repository: {} tokens: {}", (Object)repository.getName(), (Object)state.getTokens());
            return ((NpmTokenFacet)repository.facet(NpmTokenFacet.class)).logout(context);
        }
    };

    private NpmHandlers() {
    }

    @Nonnull
    static NpmPackageId packageId(TokenMatcher.State state) {
        Preconditions.checkNotNull((Object)state);
        String packageName = (String)state.getTokens().get(T_PACKAGE_NAME);
        Preconditions.checkNotNull((Object)packageName);
        String version = (String)state.getTokens().get(T_PACKAGE_VERSION);
        if (!Strings2.isBlank((String)version)) {
            packageName = String.valueOf(packageName) + "-" + version;
        }
        String packageScope = (String)state.getTokens().get(T_PACKAGE_SCOPE);
        return new NpmPackageId(packageScope, packageName);
    }

    @Nonnull
    static String tarballName(TokenMatcher.State state) {
        Preconditions.checkNotNull((Object)state);
        String tarballName = (String)state.getTokens().get(T_TARBALL_NAME);
        Preconditions.checkNotNull((Object)tarballName);
        return tarballName;
    }

    @Nullable
    static DateTime indexSince(Parameters parameters) {
        String tsStr;
        if (parameters != null && "update_after".equals(parameters.get("stale")) && !Strings2.isBlank((String)(tsStr = parameters.get("startkey")))) {
            try {
                return new DateTime(Long.parseLong(tsStr));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return null;
    }

    @Nullable
    private static String revision(TokenMatcher.State state) {
        Preconditions.checkNotNull((Object)state);
        return (String)state.getTokens().get(T_REVISION);
    }
}

