/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.npm.internal;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.repository.npm.internal.NpmAttributes;
import org.sonatype.nexus.repository.npm.internal.NpmFacetUtils;
import org.sonatype.nexus.repository.npm.internal.NpmHostedFacet;
import org.sonatype.nexus.repository.npm.internal.NpmMetadataUtils;
import org.sonatype.nexus.repository.npm.internal.NpmPackageId;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.DefaultComponentMaintenanceImpl;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalDeleteBlob;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class NpmHostedComponentMaintenanceImpl
extends DefaultComponentMaintenanceImpl {
    @TransactionalDeleteBlob
    protected Set<String> deleteComponentTx(EntityId componentId, boolean deleteBlobs) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Component component = tx.findComponentInBucket(componentId, tx.findBucket(this.getRepository()));
        if (component == null) {
            return Collections.emptySet();
        }
        HashSet<String> deletedAssets = new HashSet<String>();
        tx.browseAssets(component).forEach(a -> {
            boolean bl2 = deletedAssets.addAll(this.deleteAssetTx((Asset)a, deleteBlobs));
        });
        return deletedAssets;
    }

    @TransactionalDeleteBlob
    protected Set<String> deleteAssetTx(EntityId assetId, boolean deleteBlob) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = tx.findAsset(assetId, tx.findBucket(this.getRepository()));
        if (asset == null) {
            return Collections.emptySet();
        }
        return this.deleteAssetTx(asset, deleteBlob);
    }

    private Set<String> deleteAssetTx(Asset asset, boolean deleteBlob) {
        NpmAttributes.AssetKind assetKind = NpmAttributes.AssetKind.valueOf((String)asset.formatAttributes().get("asset_kind", String.class));
        HashSet<String> deletedAssets = new HashSet<String>();
        try {
            if (NpmAttributes.AssetKind.PACKAGE_ROOT == assetKind) {
                NpmPackageId packageId = NpmPackageId.parse(asset.name());
                deletedAssets.addAll(this.deletePackageRoot(packageId, deleteBlob));
            } else if (NpmAttributes.AssetKind.TARBALL == assetKind) {
                NpmPackageId packageId = NpmPackageId.parse(asset.name().substring(0, asset.name().indexOf("/-/")));
                String tarballName = NpmMetadataUtils.extractTarballName(asset.name());
                deletedAssets.addAll(this.deleteTarball(packageId, tarballName, deleteBlob));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return deletedAssets;
    }

    private Set<String> deletePackageRoot(NpmPackageId packageId, boolean deleteBlob) throws IOException {
        return ((NpmHostedFacet)this.getRepository().facet(NpmHostedFacet.class)).deletePackage(packageId, null, deleteBlob);
    }

    private Set<String> deleteTarball(NpmPackageId packageId, String tarballName, boolean deleteBlob) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset packageRootAsset = NpmFacetUtils.findPackageRootAsset(tx, tx.findBucket(this.getRepository()), packageId);
        if (packageRootAsset == null) {
            return Collections.emptySet();
        }
        NestedAttributesMap packageRoot = NpmFacetUtils.loadPackageRoot(tx, packageRootAsset);
        NestedAttributesMap version = NpmMetadataUtils.selectVersionByTarballName(packageRoot, tarballName);
        if (version == null) {
            return Collections.emptySet();
        }
        packageRoot.child("versions").remove(version.getKey());
        if (packageRoot.child("versions").isEmpty()) {
            return ((NpmHostedFacet)this.getRepository().facet(NpmHostedFacet.class)).deletePackage(packageId, null, deleteBlob);
        }
        Iterator distTags = packageRoot.child("dist-tags").iterator();
        while (distTags.hasNext()) {
            Map.Entry distTag = (Map.Entry)distTags.next();
            if (!version.getKey().equals(distTag.getValue())) continue;
            distTags.remove();
        }
        packageRoot.child("time").remove(version.getKey());
        NpmMetadataUtils.maintainTime(packageRoot);
        NpmFacetUtils.savePackageRoot((StorageTx)UnitOfWork.currentTx(), packageRootAsset, packageRoot);
        return ((NpmHostedFacet)this.getRepository().facet(NpmHostedFacet.class)).deleteTarball(packageId, tarballName, deleteBlob);
    }
}

