/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.npm.internal;

import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.entity.EntityHelper;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.npm.NpmFacet;
import org.sonatype.nexus.repository.npm.internal.NpmFacetUtils;
import org.sonatype.nexus.repository.npm.internal.NpmHostedFacet;
import org.sonatype.nexus.repository.npm.internal.NpmMetadataUtils;
import org.sonatype.nexus.repository.npm.internal.NpmPackageId;
import org.sonatype.nexus.repository.npm.internal.NpmPackageRootMetadataUtils;
import org.sonatype.nexus.repository.npm.internal.NpmPublishRequest;
import org.sonatype.nexus.repository.npm.internal.NpmRequestParser;
import org.sonatype.nexus.repository.npm.internal.NpmVersionComparator;
import org.sonatype.nexus.repository.npm.internal.NpmWritePolicySelector;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.storage.TempBlob;
import org.sonatype.nexus.repository.storage.WritePolicySelector;
import org.sonatype.nexus.repository.transaction.TransactionalDeleteBlob;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class NpmHostedFacetImpl
extends FacetSupport
implements NpmHostedFacet {
    private final NpmRequestParser npmRequestParser;

    @Inject
    public NpmHostedFacetImpl(NpmRequestParser npmRequestParser) {
        this.npmRequestParser = (NpmRequestParser)((Object)Preconditions.checkNotNull((Object)((Object)npmRequestParser)));
    }

    protected void doInit(Configuration configuration) throws Exception {
        super.doInit(configuration);
        ((StorageFacet)this.getRepository().facet(StorageFacet.class)).registerWritePolicySelector((WritePolicySelector)new NpmWritePolicySelector());
    }

    @Override
    @Nullable
    @TransactionalTouchBlob
    public Content getPackage(NpmPackageId packageId) throws IOException {
        Preconditions.checkNotNull((Object)packageId);
        this.log.debug("Getting package: {}", (Object)packageId);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset packageRootAsset = NpmFacetUtils.findPackageRootAsset(tx, tx.findBucket(this.getRepository()), packageId);
        if (packageRootAsset == null) {
            return null;
        }
        NestedAttributesMap packageRoot = NpmFacetUtils.loadPackageRoot(tx, packageRootAsset);
        this.maybeAddRevision(packageRootAsset, packageRoot);
        NpmMetadataUtils.rewriteTarballUrl(this.getRepository().getName(), packageRoot);
        return NpmFacetUtils.toContent(packageRootAsset, packageRoot);
    }

    @TransactionalStoreBlob
    protected void maybeAddRevision(Asset packageRootAsset, NestedAttributesMap packageRoot) {
        if (!packageRoot.contains("_rev")) {
            String newRevision = EntityHelper.version((Entity)packageRootAsset).getValue();
            packageRoot.set("_id", (Object)packageRootAsset.name());
            packageRoot.set("_rev", (Object)newRevision);
            try {
                NpmFacetUtils.savePackageRoot((StorageTx)UnitOfWork.currentTx(), packageRootAsset, packageRoot);
            }
            catch (IOException e) {
                this.log.error("Failed to update revision in package root {}", packageRoot.get("name"), (Object)e);
            }
        }
    }

    @Override
    public void putPackage(NpmPackageId packageId, @Nullable String revision, Payload payload) throws IOException {
        Preconditions.checkNotNull((Object)packageId);
        Preconditions.checkNotNull((Object)payload);
        Throwable throwable = null;
        Object var5_6 = null;
        try (NpmPublishRequest request = this.npmRequestParser.parsePublish(this.getRepository(), payload);){
            this.putPublishRequest(packageId, revision, request);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Asset putPackage(Map<String, Object> packageJson, TempBlob tempBlob) throws IOException {
        Preconditions.checkNotNull(packageJson);
        Preconditions.checkNotNull((Object)tempBlob);
        this.log.debug("Storing package: {}", packageJson);
        Preconditions.checkNotNull((Object)packageJson.get("name"), (Object)"Uploaded package is invalid, or is missing package.json");
        NestedAttributesMap metadata = NpmPackageRootMetadataUtils.createFullPackageMetadata(new NestedAttributesMap("metadata", packageJson), this.getRepository().getName(), ((HashCode)tempBlob.getHashes().get(HashAlgorithm.SHA1)).toString(), null, NpmVersionComparator.extractAlwaysPackageVersion);
        NpmPackageId packageId = NpmPackageId.parse((String)metadata.get("name"));
        return this.putPackage(packageId, metadata, tempBlob);
    }

    @TransactionalStoreBlob
    protected Asset putPackage(NpmPackageId packageId, NestedAttributesMap requestPackageRoot, TempBlob tarballTempBlob) throws IOException {
        Preconditions.checkNotNull((Object)packageId);
        Preconditions.checkNotNull((Object)requestPackageRoot);
        Preconditions.checkNotNull((Object)tarballTempBlob);
        this.log.debug("Storing package: {}", (Object)packageId);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        String tarballName = NpmMetadataUtils.extractTarballName(requestPackageRoot);
        AssetBlob assetBlob = NpmFacetUtils.createTarballAssetBlob(tx, packageId, tarballName, tarballTempBlob);
        NpmFacet npmFacet = (NpmFacet)this.facet(NpmFacet.class);
        Asset asset = npmFacet.putTarball(packageId.id(), tarballName, assetBlob, new AttributesMap());
        this.putPackageRoot(packageId, null, requestPackageRoot);
        return asset;
    }

    @TransactionalStoreBlob
    protected void putPublishRequest(NpmPackageId packageId, @Nullable String revision, NpmPublishRequest request) throws IOException {
        this.log.debug("Storing package: {}", (Object)packageId);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        NestedAttributesMap packageRoot = request.getPackageRoot();
        NestedAttributesMap attachments = packageRoot.child("_attachments");
        if (!attachments.isEmpty()) {
            for (String name : attachments.keys()) {
                NestedAttributesMap attachment = attachments.child(name);
                NestedAttributesMap packageVersion = NpmMetadataUtils.selectVersionByTarballName(packageRoot, name);
                this.putTarball(tx, packageId, packageVersion, attachment, request);
            }
        }
        this.putPackageRoot(packageId, revision, packageRoot);
    }

    @Override
    @TransactionalStoreBlob
    public void putPackageRoot(NpmPackageId packageId, @Nullable String revision, NestedAttributesMap newPackageRoot) throws IOException {
        this.log.debug("Storing package root: {}", (Object)packageId);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        boolean update = false;
        NestedAttributesMap packageRoot = newPackageRoot;
        Asset packageRootAsset = NpmFacetUtils.findPackageRootAsset(tx, bucket, packageId);
        if (packageRootAsset != null) {
            NestedAttributesMap oldPackageRoot = NpmFacetUtils.loadPackageRoot(tx, packageRootAsset);
            String rev = revision;
            if (rev == null) {
                rev = (String)packageRoot.get("_rev", String.class);
            }
            if (rev != null) {
                Preconditions.checkArgument((boolean)rev.equals(oldPackageRoot.get("_rev", String.class)));
                update = true;
            } else {
                packageRoot = NpmMetadataUtils.overlay(oldPackageRoot, packageRoot);
            }
        }
        boolean createdPackageRoot = false;
        if (packageRootAsset == null) {
            packageRootAsset = (Asset)tx.createAsset(bucket, this.getRepository().getFormat()).name(packageId.id());
            createdPackageRoot = true;
        }
        this.updateRevision(packageRoot, packageRootAsset, createdPackageRoot);
        NpmFacetUtils.savePackageRoot(tx, packageRootAsset, packageRoot);
        if (update) {
            this.updateDeprecationFlags(tx, packageId, packageRoot);
        }
    }

    private void updateRevision(NestedAttributesMap packageRoot, Asset packageRootAsset, boolean createdPackageRoot) {
        String newRevision = "1";
        if (!createdPackageRoot) {
            if (packageRoot.contains("_rev")) {
                String rev = (String)packageRoot.get("_rev", String.class);
                newRevision = Integer.toString(Integer.parseInt(rev) + 1);
            } else {
                newRevision = EntityHelper.version((Entity)packageRootAsset).getValue();
            }
        }
        packageRoot.set("_id", (Object)packageRootAsset.name());
        packageRoot.set("_rev", (Object)newRevision);
    }

    private void updateDeprecationFlags(StorageTx tx, NpmPackageId packageId, NestedAttributesMap packageRoot) {
        NestedAttributesMap versions = packageRoot.child("versions");
        for (Component tarballComponent : NpmFacetUtils.findPackageTarballComponents(tx, this.getRepository(), packageId)) {
            boolean deprecated;
            Preconditions.checkState((boolean)versions.contains(tarballComponent.version()), (String)"Package %s lacks tarball version %s", (Object)packageId, (Object)tarballComponent.version());
            NestedAttributesMap version = versions.child(tarballComponent.version());
            String deprecationMessage = (String)version.get("deprecated", String.class);
            boolean bl = deprecated = !Strings2.isBlank((String)deprecationMessage);
            if (deprecated && !deprecationMessage.equals(tarballComponent.formatAttributes().get("deprecated", String.class))) {
                tarballComponent.formatAttributes().set("deprecated", (Object)deprecationMessage);
                tx.saveComponent(tarballComponent);
                continue;
            }
            if (deprecated || !tarballComponent.formatAttributes().contains("deprecated")) continue;
            tarballComponent.formatAttributes().remove("deprecated");
            tx.saveComponent(tarballComponent);
        }
    }

    private void putTarball(StorageTx tx, NpmPackageId packageId, NestedAttributesMap packageVersion, NestedAttributesMap attachment, NpmPublishRequest request) throws IOException {
        String tarballName = NpmMetadataUtils.extractTarballName(attachment.getKey());
        this.log.debug("Storing tarball: {}@{} ({})", new Object[]{packageId, packageVersion.get("version", String.class), tarballName});
        TempBlob tempBlob = request.requireBlob((String)attachment.require("data", String.class));
        AssetBlob assetBlob = NpmFacetUtils.createTarballAssetBlob(tx, packageId, tarballName, tempBlob);
        NpmFacet npmFacet = (NpmFacet)this.facet(NpmFacet.class);
        npmFacet.putTarball(packageId.id(), tarballName, assetBlob, new AttributesMap());
    }

    @Override
    @TransactionalDeleteBlob
    public Set<String> deletePackage(NpmPackageId packageId, @Nullable String revision) throws IOException {
        return this.deletePackage(packageId, revision, true);
    }

    @Override
    @TransactionalDeleteBlob
    public Set<String> deletePackage(NpmPackageId packageId, @Nullable String revision, boolean deleteBlobs) throws IOException {
        Asset packageRootAsset;
        Preconditions.checkNotNull((Object)packageId);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        if (revision != null && (packageRootAsset = NpmFacetUtils.findPackageRootAsset(tx, tx.findBucket(this.getRepository()), packageId)) != null) {
            NestedAttributesMap oldPackageRoot = NpmFacetUtils.loadPackageRoot(tx, packageRootAsset);
            Preconditions.checkArgument((boolean)revision.equals(oldPackageRoot.get("_rev", String.class)));
        }
        return NpmFacetUtils.deletePackageRoot(tx, this.getRepository(), packageId, deleteBlobs);
    }

    @Override
    @Nullable
    @TransactionalTouchBlob
    public Content getTarball(NpmPackageId packageId, String tarballName) throws IOException {
        Preconditions.checkNotNull((Object)packageId);
        Preconditions.checkNotNull((Object)tarballName);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        return NpmFacetUtils.getTarballContent(tx, tx.findBucket(this.getRepository()), packageId, tarballName);
    }

    @Override
    @TransactionalDeleteBlob
    public Set<String> deleteTarball(NpmPackageId packageId, String tarballName) {
        return this.deleteTarball(packageId, tarballName, true);
    }

    @Override
    @TransactionalDeleteBlob
    public Set<String> deleteTarball(NpmPackageId packageId, String tarballName, boolean deleteBlob) {
        Preconditions.checkNotNull((Object)packageId);
        Preconditions.checkNotNull((Object)tarballName);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        Asset tarballAsset = NpmFacetUtils.findTarballAsset(tx, bucket, packageId, tarballName);
        if (tarballAsset == null) {
            return Collections.emptySet();
        }
        Component tarballComponent = tx.findComponentInBucket(tarballAsset.componentId(), bucket);
        if (tarballComponent == null) {
            return Collections.emptySet();
        }
        return tx.deleteComponent(tarballComponent, deleteBlob);
    }
}

