/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.npm.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.sonatype.nexus.common.app.BaseUrlHolder;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.npm.internal.NpmPackageId;
import org.sonatype.nexus.repository.npm.internal.NpmVersionComparator;

public final class NpmMetadataUtils {
    @VisibleForTesting
    static final DateTimeFormatter NPM_TIMESTAMP_FORMAT = ISODateTimeFormat.dateTime().withZone(DateTimeZone.UTC);
    static final String NAME = "name";
    static final String DIST_TAGS = "dist-tags";
    static final String VERSIONS = "versions";
    static final String VERSION = "version";
    static final String DEPRECATED = "deprecated";
    static final String TIME = "time";
    private static final String MODIFIED = "modified";
    private static final String CREATED = "created";
    private static final String LATEST = "latest";
    static final String DIST = "dist";
    static final String TARBALL = "tarball";
    static final String META_ID = "_id";
    static final String META_REV = "_rev";
    public static final String META_UPDATED = "_updated";
    private static final String AUTHOR = "author";
    private static final String DEPENDENCIES = "dependencies";
    private static final String DEV_DEPENDENCIES = "devDependencies";
    private static final String PUBLISH_CONFIG = "publishConfig";
    private static final String SCRIPTS = "scripts";

    private NpmMetadataUtils() {
    }

    @Nonnull
    static String extractTarballName(String tarballUrl) {
        int idx = tarballUrl.lastIndexOf(47);
        if (idx != -1) {
            return tarballUrl.substring(idx + 1);
        }
        return tarballUrl;
    }

    @Nullable
    static String extractTarballName(NestedAttributesMap packageMetadata) {
        String version = (String)packageMetadata.child(DIST_TAGS).get(LATEST, String.class);
        if (version == null) {
            return null;
        }
        String url = (String)packageMetadata.child(VERSIONS).child(version).child(DIST).get(TARBALL, String.class);
        if (url == null) {
            return null;
        }
        return NpmMetadataUtils.extractTarballName(url);
    }

    @Nullable
    static NestedAttributesMap selectVersionByTarballName(NestedAttributesMap packageRoot, String tarballName) {
        String extractedTarballName = NpmMetadataUtils.extractTarballName(tarballName);
        NestedAttributesMap versions = packageRoot.child(VERSIONS);
        for (String v : versions.keys()) {
            NestedAttributesMap version = versions.child(v);
            String versionTarballUrl = (String)version.child(DIST).get(TARBALL, String.class);
            if (!extractedTarballName.equals(NpmMetadataUtils.extractTarballName(versionTarballUrl))) continue;
            return version;
        }
        return null;
    }

    static DateTime maintainTime(NestedAttributesMap packageRoot) {
        NestedAttributesMap time = packageRoot.child(TIME);
        DateTime now = DateTime.now();
        String nowString = NPM_TIMESTAMP_FORMAT.print((ReadableInstant)now);
        if (!time.contains(CREATED)) {
            time.set(CREATED, (Object)nowString);
        }
        time.set(MODIFIED, (Object)nowString);
        for (String version : packageRoot.child(VERSIONS).keys()) {
            if (time.contains(version)) continue;
            time.set(version, (Object)nowString);
        }
        return now;
    }

    @Nullable
    public static DateTime lastModified(NestedAttributesMap packageRoot) {
        NestedAttributesMap time = packageRoot.child(TIME);
        String modified = (String)time.get(MODIFIED, String.class);
        if (modified != null) {
            return NPM_TIMESTAMP_FORMAT.parseDateTime(modified);
        }
        return null;
    }

    static void rewriteTarballUrl(String repositoryName, NestedAttributesMap packageRoot) {
        if (BaseUrlHolder.isSet()) {
            NestedAttributesMap versions = packageRoot.child(VERSIONS);
            for (String v : versions.keys()) {
                if (!(versions.get(v) instanceof Map)) continue;
                NestedAttributesMap version = versions.child(v);
                NestedAttributesMap dist = version.child(DIST);
                String tarballName = NpmMetadataUtils.extractTarballName((String)dist.get(TARBALL, String.class));
                dist.set(TARBALL, (Object)String.format("%s/repository/%s/%s/-/%s", BaseUrlHolder.get(), repositoryName, version.get(NAME), tarballName));
            }
        }
    }

    public static String createRepositoryPath(String name, String version) {
        NpmPackageId packageId = NpmPackageId.parse(name);
        return String.format("%s/-/%s-%s.tgz", packageId.id(), packageId.name(), version);
    }

    @Nonnull
    public static NestedAttributesMap shrink(NestedAttributesMap packageRoot) {
        NestedAttributesMap versions = packageRoot.child(VERSIONS);
        for (Map.Entry version : versions) {
            version.setValue(NpmMetadataUtils.resolveVersionToTag(packageRoot, (String)version.getKey()));
        }
        return packageRoot;
    }

    @Nonnull
    static NestedAttributesMap overlay(NestedAttributesMap recessive, NestedAttributesMap dominant) {
        NpmMetadataUtils.overlay(recessive.backing(), dominant.backing(), true);
        return recessive;
    }

    @Nonnull
    public static NestedAttributesMap merge(String key, List<NestedAttributesMap> packages) {
        NestedAttributesMap result = new NestedAttributesMap(key, (Map)Maps.newHashMap());
        String latestVersion = null;
        for (NestedAttributesMap pkg : packages) {
            String pkgLatestVersion = (String)pkg.child(DIST_TAGS).get(LATEST, String.class);
            if (pkgLatestVersion != null && (latestVersion == null || NpmVersionComparator.versionComparator.compare(pkgLatestVersion, latestVersion) > 0)) {
                latestVersion = pkgLatestVersion;
            }
            NpmMetadataUtils.overlay(result.backing(), pkg.backing(), false);
        }
        result.child(DIST_TAGS).set(LATEST, latestVersion);
        result.remove(META_ID);
        result.remove(META_REV);
        return result;
    }

    private static Map<String, Object> overlay(Map<String, Object> recessive, Map<String, Object> dominant, boolean mergeVersionDocuments) {
        for (Map.Entry<String, Object> dominantEntry : dominant.entrySet()) {
            String key = dominantEntry.getKey();
            Object recessiveValue = recessive.get(key);
            Object dominantValue = dominantEntry.getValue();
            if (dominantValue instanceof Map && recessiveValue instanceof Map) {
                Map recessiveChild = (Map)recessiveValue;
                Map dominantChild = (Map)dominantValue;
                if (NpmMetadataUtils.isSpecialOverlayKey(key)) {
                    recessive.put(key, dominantValue);
                    continue;
                }
                if (mergeVersionDocuments || !VERSIONS.equals(key)) {
                    recessive.put(key, NpmMetadataUtils.overlay(recessiveChild, dominantChild, mergeVersionDocuments));
                    continue;
                }
                for (Map.Entry dominantVersion : dominantChild.entrySet()) {
                    recessiveChild.put(String.valueOf(dominantVersion.getKey()), dominantVersion.getValue());
                }
                continue;
            }
            if (dominantValue instanceof String && recessiveValue instanceof Map) continue;
            recessive.put(key, dominantValue);
        }
        return recessive;
    }

    private static boolean isSpecialOverlayKey(String key) {
        return DEPENDENCIES.equals(key) || DEV_DEPENDENCIES.equals(key) || SCRIPTS.equals(key) || AUTHOR.equals(key) || PUBLISH_CONFIG.equals(key);
    }

    private static String resolveVersionToTag(NestedAttributesMap packageRoot, String version) {
        NestedAttributesMap distTags = packageRoot.child(DIST_TAGS);
        if (!distTags.isEmpty()) {
            for (Map.Entry distTag : distTags) {
                if (!version.equals(distTag.getValue())) continue;
                return (String)distTag.getKey();
            }
        }
        return version;
    }

    public static String getLatestVersionFromPackageRoot(NestedAttributesMap pkg) {
        return (String)pkg.child(DIST_TAGS).get(LATEST, String.class);
    }
}

