/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.npm.internal;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.npm.internal.NpmFacetUtils;
import org.sonatype.nexus.repository.npm.internal.NpmMetadataUtils;
import org.sonatype.nexus.repository.npm.internal.NpmPackageId;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.transaction.UnitOfWork;

public class NpmPackageRootMetadataUtils {
    private static final String MODIFIED = "modified";
    private static final String CREATED = "created";
    private static final String LATEST = "latest";
    private static final String DEPENDENCIES = "dependencies";
    private static final String DEV_DEPENDENCIES = "devDependencies";
    private static final String[] FULL_HOISTED_FIELDS = new String[]{"author", "contributors", "description", "homepage", "keywords", "license", "maintainers", "name", "readme", "readmeFilename", "repository"};
    private static final String[] FULL_VERSION_MAP_FIELDS = new String[]{"author", "contributors", "deprecated", "dependencies", "description", "license", "main", "maintainers", "name", "version", "optionalDependencies", "devDependencies", "bundleDependencies", "peerDependencies", "bin", "directories", "engines", "readme", "readmeFilename", "_hasShrinkwrap"};

    private NpmPackageRootMetadataUtils() {
    }

    public static NestedAttributesMap createFullPackageMetadata(NestedAttributesMap packageJson, String repositoryName, String sha1sum, @Nullable Repository repository, BiFunction<String, String, String> function) {
        String name = (String)packageJson.get("name", String.class);
        String version = (String)packageJson.get("version", String.class);
        String now = NpmMetadataUtils.NPM_TIMESTAMP_FORMAT.print((ReadableInstant)DateTime.now());
        NestedAttributesMap packageRoot = new NestedAttributesMap("metadata", new HashMap());
        packageRoot.set("_id", (Object)name);
        String packageRootLatestVersion = Objects.isNull(repository) ? "" : NpmPackageRootMetadataUtils.getPackageRootLatestVersion(packageJson, repository);
        packageRoot.child("dist-tags").set(LATEST, (Object)function.apply(packageRootLatestVersion, version));
        packageRoot.child("users");
        NestedAttributesMap time = packageRoot.child("time");
        time.set(version, (Object)now);
        time.set(MODIFIED, (Object)now);
        time.set(CREATED, (Object)now);
        NpmPackageRootMetadataUtils.setBugsUrl(packageJson, packageRoot);
        String[] stringArray = FULL_HOISTED_FIELDS;
        int n = FULL_HOISTED_FIELDS.length;
        int n2 = 0;
        while (n2 < n) {
            String field = stringArray[n2];
            NpmPackageRootMetadataUtils.copy(packageRoot, packageJson, field);
            ++n2;
        }
        NestedAttributesMap versionMap = packageRoot.child("versions").child(version);
        versionMap.set("_id", (Object)(String.valueOf(name) + "@" + version));
        versionMap.child("dist").set("shasum", (Object)sha1sum);
        versionMap.child("dist").set("tarball", (Object)String.format("%s/repository/%s", repositoryName, NpmMetadataUtils.createRepositoryPath(name, version)));
        String[] stringArray2 = FULL_VERSION_MAP_FIELDS;
        int n3 = FULL_VERSION_MAP_FIELDS.length;
        n = 0;
        while (n < n3) {
            String field = stringArray2[n];
            NpmPackageRootMetadataUtils.copy(versionMap, packageJson, field);
            ++n;
        }
        NpmMetadataUtils.rewriteTarballUrl(repositoryName, packageRoot);
        return packageRoot;
    }

    private static String getPackageRootLatestVersion(NestedAttributesMap packageJson, Repository repository) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        NpmPackageId packageId = NpmPackageId.parse((String)packageJson.get("name"));
        try {
            String latestVersion;
            NestedAttributesMap packageRoot = NpmPackageRootMetadataUtils.getPackageRoot(tx, repository, packageId);
            if (Objects.nonNull(packageRoot) && Objects.nonNull(latestVersion = NpmMetadataUtils.getLatestVersionFromPackageRoot(packageRoot))) {
                return latestVersion;
            }
        }
        catch (IOException iOException) {}
        return "";
    }

    @Nullable
    public static NestedAttributesMap getPackageRoot(StorageTx tx, Repository repository, NpmPackageId packageId) throws IOException {
        Bucket bucket = tx.findBucket(repository);
        Asset packageRootAsset = NpmFacetUtils.findPackageRootAsset(tx, bucket, packageId);
        if (packageRootAsset != null) {
            return NpmFacetUtils.loadPackageRoot(tx, packageRootAsset);
        }
        return null;
    }

    private static void copy(NestedAttributesMap map, NestedAttributesMap src, String field) {
        Object object = src.get(field);
        if (object instanceof Map) {
            NestedAttributesMap destChild = map.child(field);
            NestedAttributesMap srcChild = src.child(field);
            for (String key : srcChild.keys()) {
                if (srcChild.get(field) instanceof Map) {
                    NpmPackageRootMetadataUtils.copy(destChild, srcChild, key);
                    continue;
                }
                destChild.set(key, srcChild.get(key));
            }
        } else if (object != null) {
            map.set(field, object);
        }
    }

    private static void setBugsUrl(NestedAttributesMap packageJson, NestedAttributesMap packageRoot) {
        Object bugs = packageJson.get("bugs");
        String bugsUrl = null;
        if (bugs instanceof String) {
            bugsUrl = (String)bugs;
        } else if (bugs != null) {
            bugsUrl = (String)packageJson.child("bugs").get("url", String.class);
        }
        if (bugsUrl != null) {
            packageRoot.set("bugs", (Object)bugsUrl);
        }
    }
}

