/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.npm.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Named;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.cache.CacheController;
import org.sonatype.nexus.repository.cache.CacheControllerHolder;
import org.sonatype.nexus.repository.cache.CacheInfo;
import org.sonatype.nexus.repository.npm.NpmFacet;
import org.sonatype.nexus.repository.npm.internal.NpmFacetUtils;
import org.sonatype.nexus.repository.npm.internal.NpmHandlers;
import org.sonatype.nexus.repository.npm.internal.NpmMetadataUtils;
import org.sonatype.nexus.repository.npm.internal.NpmPackageId;
import org.sonatype.nexus.repository.npm.internal.search.legacy.NpmSearchIndexFilter;
import org.sonatype.nexus.repository.npm.internal.search.legacy.NpmSearchIndexInvalidatedEvent;
import org.sonatype.nexus.repository.proxy.ProxyFacetSupport;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.MissingBlobException;
import org.sonatype.nexus.repository.storage.RetryDeniedException;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.storage.TempBlob;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;
import org.sonatype.nexus.repository.transaction.TransactionalTouchMetadata;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Parameters;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.ViewFacet;
import org.sonatype.nexus.repository.view.ViewUtils;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class NpmProxyFacetImpl
extends ProxyFacetSupport {
    @Nullable
    protected Content fetch(Context context, Content stale) throws IOException {
        try {
            return super.fetch(context, stale);
        }
        catch (NonResolvableTarballNameException e) {
            this.log.debug("npm tarball URL not resolvable: {}", (Object)e.getMessage());
            return null;
        }
    }

    protected Content getCachedContent(Context context) throws IOException {
        ProxyTarget proxyTarget = (ProxyTarget)((Object)context.getAttributes().require(ProxyTarget.class));
        if (proxyTarget.equals((Object)ProxyTarget.SEARCH_V1_RESULTS)) {
            return null;
        }
        if (ProxyTarget.PACKAGE == proxyTarget) {
            return this.getPackageRoot(NpmHandlers.packageId(this.matcherState(context)));
        }
        if (ProxyTarget.TARBALL == proxyTarget) {
            TokenMatcher.State state = this.matcherState(context);
            return this.getTarball(NpmHandlers.packageId(state), NpmHandlers.tarballName(state));
        }
        if (ProxyTarget.SEARCH_INDEX == proxyTarget) {
            Content fullIndex = this.getRepositoryRoot();
            if (fullIndex == null) {
                return null;
            }
            return NpmSearchIndexFilter.filterModifiedSince(fullIndex, NpmHandlers.indexSince(context.getRequest().getParameters()));
        }
        throw new IllegalStateException();
    }

    @Nonnull
    protected CacheController getCacheController(@Nonnull Context context) {
        ProxyTarget proxyTarget = (ProxyTarget)((Object)context.getAttributes().require(ProxyTarget.class));
        return this.cacheControllerHolder.require(proxyTarget.getCacheType());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Content store(Context context, Content content) throws IOException {
        ProxyTarget proxyTarget = (ProxyTarget)((Object)context.getAttributes().require(ProxyTarget.class));
        if (proxyTarget.equals((Object)ProxyTarget.SEARCH_V1_RESULTS)) {
            return content;
        }
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var6_7 = null;
        try {
            Content content2;
            TempBlob tempBlob = storageFacet.createTempBlob((Payload)content, NpmFacetUtils.HASH_ALGORITHMS);
            try {
                if (ProxyTarget.PACKAGE == proxyTarget) {
                    content2 = this.putPackageRoot(NpmHandlers.packageId(this.matcherState(context)), tempBlob, content);
                    return content2;
                }
                if (ProxyTarget.TARBALL == proxyTarget) {
                    TokenMatcher.State state = this.matcherState(context);
                    return this.putTarball(NpmHandlers.packageId(state), NpmHandlers.tarballName(state), tempBlob, content, context);
                }
                if (ProxyTarget.SEARCH_INDEX != proxyTarget) throw new IllegalStateException();
                Content fullIndex = this.putRepositoryRoot(tempBlob, content);
                return NpmSearchIndexFilter.filterModifiedSince(fullIndex, NpmHandlers.indexSince(context.getRequest().getParameters()));
            }
            finally {
                if (tempBlob == null) return content2;
                tempBlob.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    protected void indicateVerified(Context context, Content content, CacheInfo cacheInfo) throws IOException {
        this.setCacheInfo(content, cacheInfo);
    }

    protected String getUrl(@Nonnull Context context) {
        Parameters parameters;
        String url = context.getRequest().getPath().substring(1);
        ProxyTarget proxyTarget = (ProxyTarget)((Object)context.getAttributes().require(ProxyTarget.class));
        if (ProxyTarget.TARBALL == proxyTarget) {
            TokenMatcher.State state = this.matcherState(context);
            try {
                NestedAttributesMap packageVersion = this.retrievePackageVersion(NpmHandlers.packageId(state), NpmHandlers.tarballName(state), context);
                url = (String)packageVersion.child("dist").get("tarball", String.class);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        } else if (ProxyTarget.PACKAGE == proxyTarget) {
            NpmPackageId packageId = NpmHandlers.packageId(this.matcherState(context));
            if (packageId.scope() != null) {
                String newUrl = "@" + packageId.scope() + "%2f" + packageId.name();
                this.log.trace("Scoped package URL fix: {} -> {}", (Object)url, (Object)newUrl);
                url = newUrl;
            }
        } else if (ProxyTarget.SEARCH_V1_RESULTS == proxyTarget && (parameters = context.getRequest().getParameters()) != null) {
            return ViewUtils.buildUrlWithParameters((String)url, (Parameters)parameters);
        }
        return url;
    }

    @TransactionalTouchMetadata
    public void setCacheInfo(Content content, CacheInfo cacheInfo) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = Content.findAsset((StorageTx)tx, (Bucket)tx.findBucket(this.getRepository()), (Content)content);
        if (asset == null) {
            this.log.debug("Attempting to set cache info for non-existent npm asset {}", content.getAttributes().require(Asset.class));
            return;
        }
        this.log.debug("Updating cacheInfo of {} to {}", (Object)asset, (Object)cacheInfo);
        CacheInfo.applyToAsset((Asset)asset, (CacheInfo)cacheInfo);
        tx.saveAsset(asset);
    }

    @Nullable
    @TransactionalTouchBlob
    public Content getPackageRoot(NpmPackageId packageId) throws IOException {
        Preconditions.checkNotNull((Object)packageId);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset packageRootAsset = NpmFacetUtils.findPackageRootAsset(tx, tx.findBucket(this.getRepository()), packageId);
        if (packageRootAsset == null) {
            return null;
        }
        NestedAttributesMap packageRoot = NpmFacetUtils.loadPackageRoot(tx, packageRootAsset);
        NpmMetadataUtils.rewriteTarballUrl(this.getRepository().getName(), packageRoot);
        return NpmFacetUtils.toContent(packageRootAsset, packageRoot);
    }

    private Content putPackageRoot(NpmPackageId packageId, TempBlob tempBlob, Content payload) throws IOException {
        Preconditions.checkNotNull((Object)packageId);
        Preconditions.checkNotNull((Object)payload);
        Preconditions.checkNotNull((Object)tempBlob);
        NestedAttributesMap packageRoot = NpmFacetUtils.parse((Supplier<InputStream>)tempBlob);
        try {
            return this.doPutPackageRoot(packageId, packageRoot, payload, true);
        }
        catch (RetryDeniedException e) {
            if (e.getCause() instanceof MissingBlobException) {
                this.log.warn("Unable to find blob {} for {}, skipping merge of package root", (Object)((MissingBlobException)e.getCause()).getBlobRef(), (Object)packageId);
                return this.doPutPackageRoot(packageId, packageRoot, payload, false);
            }
            throw e;
        }
    }

    @TransactionalStoreBlob
    protected Content doPutPackageRoot(NpmPackageId packageId, NestedAttributesMap packageRoot, Content content, boolean mergePackageRoot) throws IOException {
        this.log.debug("Storing package: {}", (Object)packageId);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        NestedAttributesMap newPackageRoot = packageRoot;
        Asset asset = NpmFacetUtils.findPackageRootAsset(tx, bucket, packageId);
        if (asset == null) {
            asset = (Asset)tx.createAsset(bucket, this.getRepository().getFormat()).name(packageId.id());
        } else if (mergePackageRoot) {
            newPackageRoot = this.mergeNewRootWithExistingRoot(tx, newPackageRoot, asset);
        }
        Content.applyToAsset((Asset)asset, (AttributesMap)Content.maintainLastModified((Asset)asset, (AttributesMap)content.getAttributes()));
        NpmFacetUtils.savePackageRoot(tx, asset, newPackageRoot);
        NestedAttributesMap storedPackageRoot = NpmFacetUtils.loadPackageRoot(tx, asset);
        NpmMetadataUtils.rewriteTarballUrl(this.getRepository().getName(), storedPackageRoot);
        return NpmFacetUtils.toContent(asset, storedPackageRoot);
    }

    private NestedAttributesMap mergeNewRootWithExistingRoot(StorageTx tx, NestedAttributesMap newPackageRoot, Asset asset) throws IOException {
        NestedAttributesMap existingPackageRoot = NpmFacetUtils.loadPackageRoot(tx, asset);
        List<String> cachedVersions = this.findCachedVersionsRemovedFromRemote(existingPackageRoot, newPackageRoot, tx);
        NestedAttributesMap mergedRoot = newPackageRoot;
        if (!cachedVersions.isEmpty()) {
            mergedRoot = NpmMetadataUtils.merge(existingPackageRoot.getKey(), (List<NestedAttributesMap>)ImmutableList.of((Object)existingPackageRoot, (Object)newPackageRoot));
            this.removeVersionsNotCachedAndNotInNewRoot(mergedRoot, existingPackageRoot, cachedVersions);
        }
        return mergedRoot;
    }

    private void removeVersionsNotCachedAndNotInNewRoot(NestedAttributesMap newPackageRoot, NestedAttributesMap existingPackageRoot, List<String> cachedVersions) {
        for (String version : newPackageRoot.child("versions").keys()) {
            if (cachedVersions.contains(version) || existingPackageRoot.child("versions").keys().contains(version)) continue;
            newPackageRoot.child("versions").remove(version);
        }
    }

    private List<String> findCachedVersionsRemovedFromRemote(NestedAttributesMap cachedRoot, NestedAttributesMap newPackageRoot, StorageTx tx) {
        ArrayList<String> cachedVersionsRemovedFromRemote = new ArrayList<String>();
        Set newVersions = newPackageRoot.child("versions").keys();
        NpmPackageId packageId = NpmPackageId.parse((String)Preconditions.checkNotNull((Object)newPackageRoot.get("name")));
        for (String version : cachedRoot.child("versions").keys()) {
            if (newVersions.contains(version) || !tx.componentExists(packageId.scope(), packageId.name(), version, this.getRepository())) continue;
            cachedVersionsRemovedFromRemote.add(version);
        }
        return cachedVersionsRemovedFromRemote;
    }

    @Nullable
    @TransactionalTouchBlob
    public Content getTarball(NpmPackageId packageId, String tarballName) throws IOException {
        Preconditions.checkNotNull((Object)packageId);
        Preconditions.checkNotNull((Object)tarballName);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        return NpmFacetUtils.getTarballContent(tx, tx.findBucket(this.getRepository()), packageId, tarballName);
    }

    private Content putTarball(NpmPackageId packageId, String tarballName, TempBlob tempBlob, Content content, Context context) throws IOException {
        Preconditions.checkNotNull((Object)packageId);
        Preconditions.checkNotNull((Object)tarballName);
        Preconditions.checkNotNull((Object)tempBlob);
        Preconditions.checkNotNull((Object)content);
        Preconditions.checkNotNull((Object)context);
        return this.doPutTarball(packageId, tarballName, tempBlob, content);
    }

    @TransactionalStoreBlob
    protected Content doPutTarball(NpmPackageId packageId, String tarballName, TempBlob tempBlob, Content content) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        AssetBlob assetBlob = NpmFacetUtils.createTarballAssetBlob(tx, packageId, tarballName, tempBlob);
        NpmFacet npmFacet = (NpmFacet)this.facet(NpmFacet.class);
        npmFacet.putTarball(packageId.id(), tarballName, assetBlob, content.getAttributes());
        return NpmFacetUtils.getTarballContent(tx, tx.findBucket(this.getRepository()), packageId, tarballName);
    }

    private Content putRepositoryRoot(TempBlob tempBlob, Content content) throws IOException {
        Preconditions.checkNotNull((Object)tempBlob);
        Preconditions.checkNotNull((Object)content);
        Content result = this.doPutRepositoryRoot(tempBlob, content);
        this.getEventManager().post((Object)new NpmSearchIndexInvalidatedEvent(this.getRepository()));
        return result;
    }

    @Nullable
    @TransactionalTouchBlob
    public Content getRepositoryRoot() throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = NpmFacetUtils.findRepositoryRootAsset(tx, tx.findBucket(this.getRepository()));
        if (asset == null) {
            return null;
        }
        return NpmFacetUtils.toContent(asset, tx.requireBlob(asset.requireBlobRef()));
    }

    @TransactionalStoreBlob
    protected Content doPutRepositoryRoot(TempBlob tempBlob, Content content) throws IOException {
        Bucket bucket;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = NpmFacetUtils.findRepositoryRootAsset(tx, bucket = tx.findBucket(this.getRepository()));
        if (asset == null) {
            asset = (Asset)tx.createAsset(bucket, this.getRepository().getFormat()).name("-/all");
        }
        return NpmFacetUtils.saveRepositoryRoot(tx, asset, tempBlob, content);
    }

    protected NestedAttributesMap retrievePackageVersion(NpmPackageId packageId, String tarballName, Context context) throws IOException {
        this.retrievePackageRoot(packageId, context);
        return this.retrievePackageVersionTx(packageId, tarballName);
    }

    @TransactionalTouchBlob
    protected NestedAttributesMap retrievePackageVersionTx(NpmPackageId packageId, String tarballName) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = this.findPackageRootAsset(packageId);
        if (asset == null) {
            throw new NonResolvableTarballNameException("Could not find package " + packageId);
        }
        NestedAttributesMap packageRoot = NpmFacetUtils.loadPackageRoot(tx, asset);
        NestedAttributesMap packageVersion = NpmMetadataUtils.selectVersionByTarballName(packageRoot, tarballName);
        if (packageVersion == null) {
            throw new NonResolvableTarballNameException("Could not find package " + packageId + " version for " + tarballName);
        }
        return packageVersion;
    }

    @Nullable
    @Transactional
    public Asset findPackageRootAsset(NpmPackageId packageId) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        return NpmFacetUtils.findPackageRootAsset(tx, tx.findBucket(this.getRepository()), packageId);
    }

    private NestedAttributesMap retrievePackageRoot(NpmPackageId packageId, Context context) throws IOException {
        try {
            Request getRequest = new Request.Builder().action("GET").path("/" + packageId.id()).build();
            Response response = ((ViewFacet)this.getRepository().facet(ViewFacet.class)).dispatch(getRequest, context);
            if (response.getPayload() == null) {
                throw new IOException("Could not retrieve package " + packageId);
            }
            InputStream packageRootIn = response.getPayload().openInputStream();
            return NpmFacetUtils.parse((Supplier<InputStream>)((Supplier)() -> packageRootIn));
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new IOException(e);
        }
    }

    private TokenMatcher.State matcherState(Context context) {
        return (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
    }

    private static class NonResolvableTarballNameException
    extends RuntimeException {
        public NonResolvableTarballNameException(String message) {
            super(message);
        }
    }

    public static enum ProxyTarget {
        SEARCH_INDEX(CacheControllerHolder.METADATA),
        SEARCH_V1_RESULTS(CacheControllerHolder.METADATA),
        PACKAGE(CacheControllerHolder.METADATA),
        TARBALL(CacheControllerHolder.CONTENT);

        private final CacheControllerHolder.CacheType cacheType;

        private ProxyTarget(CacheControllerHolder.CacheType cacheType) {
            this.cacheType = (CacheControllerHolder.CacheType)Preconditions.checkNotNull((Object)cacheType);
        }

        @Nonnull
        public CacheControllerHolder.CacheType getCacheType() {
            return this.cacheType;
        }
    }
}

