/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.npm.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.npm.internal.NpmPublishRequest;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.TempBlob;
import org.sonatype.nexus.thread.io.StreamCopier;

public class NpmPublishParser
extends ComponentSupport {
    private static final String ATTACHMENTS_KEY = "_attachments";
    private static final String ATTACHMENTS_DATA_KEY = "data";
    private static final String MAINTAINERS_KEY = "maintainers";
    private static final String VERSIONS_KEY = "versions";
    private static final String NPM_USER = "_npmUser";
    public static final String NAME = "name";
    private static final String DIST_TAGS = "dist-tags";
    private final JsonParser jsonParser;
    private final StorageFacet storageFacet;
    private final List<HashAlgorithm> hashAlgorithms;
    private final Map<String, TempBlob> tempBlobs = new LinkedHashMap<String, TempBlob>();

    public NpmPublishParser(JsonParser jsonParser, StorageFacet storageFacet, List<HashAlgorithm> hashAlgorithms) {
        this.jsonParser = (JsonParser)Preconditions.checkNotNull((Object)jsonParser);
        this.storageFacet = (StorageFacet)Preconditions.checkNotNull((Object)storageFacet);
        this.hashAlgorithms = (List)Preconditions.checkNotNull(hashAlgorithms);
    }

    /*
     * Unable to fully structure code
     */
    public NpmPublishRequest parse(@Nullable String currentUserId) throws IOException {
        try {
            packageRoot = this.parsePackageRoot();
            if (currentUserId != null && !currentUserId.isEmpty()) {
                this.updateMaintainer(packageRoot, currentUserId);
            }
            return new NpmPublishRequest(packageRoot, this.tempBlobs);
        }
        catch (Throwable t) {
            ** for (tempBlob : this.tempBlobs.values())
        }
lbl-1000:
        // 1 sources

        {
            tempBlob.close();
            continue;
        }
lbl10:
        // 1 sources

        throw t;
    }

    private void updateMaintainer(NestedAttributesMap packageRoot, String currentUserId) {
        String distVersion = this.getDistTagVersion(packageRoot);
        if (distVersion != null && packageRoot.contains(VERSIONS_KEY)) {
            NestedAttributesMap versionToUpdate;
            String npmUser;
            NestedAttributesMap versionsMap = packageRoot.child(VERSIONS_KEY);
            if (versionsMap.contains(distVersion) && this.isUserTokenBasedPublish(currentUserId, npmUser = this.getNpmUser(versionToUpdate = versionsMap.child(distVersion)))) {
                this.updateNpmUser(packageRoot, currentUserId);
                this.updateMaintainerList(packageRoot, currentUserId);
                this.updateNpmUser(versionToUpdate, currentUserId);
                this.updateMaintainerList(versionToUpdate, currentUserId);
            }
        } else {
            this.log.warn("Version(s) attribute not found in package root");
        }
    }

    private boolean isUserTokenBasedPublish(String currentUserId, String npmUser) {
        return npmUser != null && !currentUserId.equals(npmUser);
    }

    private String getNpmUser(NestedAttributesMap packageEntry) {
        if (packageEntry.contains(NPM_USER)) {
            NestedAttributesMap npmUser = packageEntry.child(NPM_USER);
            return (String)npmUser.get(NAME, String.class);
        }
        return null;
    }

    private String getDistTagVersion(NestedAttributesMap packageRoot) {
        if (packageRoot.contains(DIST_TAGS)) {
            NestedAttributesMap distTag = packageRoot.child(DIST_TAGS);
            return (String)((Map.Entry)distTag.iterator().next()).getValue();
        }
        return null;
    }

    private void updateMaintainerList(NestedAttributesMap versionToUpdate, String currentUserId) {
        Object maintainersObject = versionToUpdate.get(MAINTAINERS_KEY);
        if (Objects.nonNull(maintainersObject)) {
            if (maintainersObject instanceof List) {
                List maintainers = (List)maintainersObject;
                Object maintainer = maintainers.get(0);
                if (maintainer instanceof Map) {
                    this.updateMaintainerAsMap(maintainers, currentUserId);
                } else if (maintainer instanceof String) {
                    this.updateMaintainerAsString(maintainers, currentUserId);
                }
            } else if (maintainersObject instanceof String) {
                versionToUpdate.set(MAINTAINERS_KEY, (Object)currentUserId);
            }
        }
    }

    private void updateMaintainerAsMap(List<Map<String, String>> maintainers, String currentUserId) {
        Map<String, String> latestEntry = maintainers.get(0);
        latestEntry.put(NAME, currentUserId);
    }

    private void updateMaintainerAsString(List<String> maintainers, String currentId) {
        maintainers.set(0, currentId);
    }

    private void updateNpmUser(NestedAttributesMap packageEntry, String currentUserId) {
        if (packageEntry.contains(NPM_USER)) {
            NestedAttributesMap npmUser = packageEntry.child(NPM_USER);
            npmUser.set(NAME, (Object)currentUserId);
        }
    }

    private NestedAttributesMap parsePackageRoot() throws IOException {
        LinkedHashMap<String, Object> backing = new LinkedHashMap<String, Object>();
        this.consumeToken();
        this.consumeToken();
        while (!JsonToken.END_OBJECT.equals((Object)this.currentToken())) {
            String key = this.parseFieldName();
            Object value = ATTACHMENTS_KEY.equals(key) ? this.parseAttachments() : this.parseValue();
            backing.put(key, value);
        }
        return new NestedAttributesMap(String.valueOf(backing.get(NAME)), backing);
    }

    @Nullable
    private Object parseValue() throws IOException {
        switch (this.currentToken()) {
            case START_OBJECT: {
                return this.parseObject();
            }
            case START_ARRAY: {
                return this.parseArray();
            }
            case VALUE_STRING: {
                return this.parseString();
            }
            case VALUE_NUMBER_INT: {
                return this.parseIntegerValue();
            }
            case VALUE_NUMBER_FLOAT: {
                return this.parseFloatValue();
            }
            case VALUE_TRUE: {
                return this.parseBooleanTrueValue();
            }
            case VALUE_FALSE: {
                return this.parseBooleanFalseValue();
            }
            case VALUE_NULL: {
                return this.parseNullValue();
            }
        }
        throw new IllegalStateException("Unexpected token " + this.currentToken() + " at " + this.jsonParser.getCurrentLocation());
    }

    private String parseFieldName() throws IOException {
        this.requireToken(JsonToken.FIELD_NAME);
        String fieldName = this.jsonParser.getCurrentName();
        this.consumeToken();
        return fieldName;
    }

    private Map<String, Object> parseObject() throws IOException {
        this.requireToken(JsonToken.START_OBJECT);
        this.consumeToken();
        LinkedHashMap<String, Object> entries = new LinkedHashMap<String, Object>();
        while (!JsonToken.END_OBJECT.equals((Object)this.currentToken())) {
            String key = this.parseFieldName();
            Object value = this.parseValue();
            entries.put(key, value);
        }
        this.consumeToken();
        return entries;
    }

    private List<Object> parseArray() throws IOException {
        this.requireToken(JsonToken.START_ARRAY);
        this.consumeToken();
        ArrayList<Object> entries = new ArrayList<Object>();
        while (!JsonToken.END_ARRAY.equals((Object)this.currentToken())) {
            entries.add(this.parseValue());
        }
        this.consumeToken();
        return entries;
    }

    private String parseString() throws IOException {
        this.requireToken(JsonToken.VALUE_STRING);
        String value = this.jsonParser.getValueAsString();
        this.consumeToken();
        return value;
    }

    private BigInteger parseIntegerValue() throws IOException {
        this.requireToken(JsonToken.VALUE_NUMBER_INT);
        BigInteger value = this.jsonParser.getBigIntegerValue();
        this.consumeToken();
        return value;
    }

    private BigDecimal parseFloatValue() throws IOException {
        this.requireToken(JsonToken.VALUE_NUMBER_FLOAT);
        BigDecimal value = this.jsonParser.getDecimalValue();
        this.consumeToken();
        return value;
    }

    private Boolean parseBooleanTrueValue() throws IOException {
        this.requireToken(JsonToken.VALUE_TRUE);
        Boolean value = this.jsonParser.getBooleanValue();
        this.consumeToken();
        return value;
    }

    private Boolean parseBooleanFalseValue() throws IOException {
        this.requireToken(JsonToken.VALUE_FALSE);
        Boolean value = this.jsonParser.getBooleanValue();
        this.consumeToken();
        return value;
    }

    @Nullable
    private Object parseNullValue() throws IOException {
        this.requireToken(JsonToken.VALUE_NULL);
        this.consumeToken();
        return null;
    }

    private Map<String, Object> parseAttachments() throws IOException {
        this.requireToken(JsonToken.START_OBJECT);
        this.consumeToken();
        LinkedHashMap<String, Object> attachments = new LinkedHashMap<String, Object>();
        while (!JsonToken.END_OBJECT.equals((Object)this.currentToken())) {
            String name = this.parseFieldName();
            Map<String, Object> attachment = this.parseAttachment();
            attachments.put(name, attachment);
        }
        this.consumeToken();
        return attachments;
    }

    private Map<String, Object> parseAttachment() throws IOException {
        this.requireToken(JsonToken.START_OBJECT);
        this.consumeToken();
        LinkedHashMap<String, Object> entries = new LinkedHashMap<String, Object>();
        while (!JsonToken.END_OBJECT.equals((Object)this.currentToken())) {
            String key = this.parseFieldName();
            Object value = ATTACHMENTS_DATA_KEY.equals(key) ? this.parseAttachmentData() : this.parseValue();
            entries.put(key, value);
        }
        this.consumeToken();
        return entries;
    }

    private String parseAttachmentData() throws IOException {
        try {
            TempBlob tempBlob = this.readBinaryValueIntoTempBlob();
            String id = tempBlob.getBlob().getId().toString();
            this.tempBlobs.put(id, tempBlob);
            return id;
        }
        catch (Exception e) {
            throw new IOException("failed to process attachment data", e);
        }
    }

    private TempBlob readBinaryValueIntoTempBlob() {
        return (TempBlob)new StreamCopier(this::readBinaryValue, this::createTempBlob).read();
    }

    private void readBinaryValue(OutputStream outputStream) {
        try {
            this.jsonParser.readBinaryValue(outputStream);
            this.consumeToken();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read binary value", e);
        }
    }

    private TempBlob createTempBlob(InputStream inputStream) {
        return this.storageFacet.createTempBlob(inputStream, this.hashAlgorithms);
    }

    private void requireToken(JsonToken token) throws IOException {
        if (!token.equals((Object)this.currentToken())) {
            throw new IllegalStateException("Expected " + token + " but found " + this.currentToken() + " at " + this.jsonParser.getCurrentLocation());
        }
    }

    private void consumeToken() throws IOException {
        this.jsonParser.nextToken();
    }

    private JsonToken currentToken() {
        return this.jsonParser.currentToken();
    }
}

