/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.npm.internal;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.util.Map;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.storage.TempBlob;

public class NpmPublishRequest
implements Closeable {
    private final NestedAttributesMap packageRoot;
    private final Map<String, TempBlob> tempBlobs;

    public NpmPublishRequest(NestedAttributesMap packageRoot, Map<String, TempBlob> tempBlobs) {
        this.packageRoot = (NestedAttributesMap)Preconditions.checkNotNull((Object)packageRoot);
        this.tempBlobs = (Map)Preconditions.checkNotNull(tempBlobs);
    }

    public NestedAttributesMap getPackageRoot() {
        return this.packageRoot;
    }

    public TempBlob requireBlob(String data) {
        TempBlob blob = this.tempBlobs.get(data);
        Preconditions.checkState((blob != null ? 1 : 0) != 0, (Object)("Missing temporary blob: " + data));
        return blob;
    }

    @Override
    public void close() {
        for (TempBlob tempBlob : this.tempBlobs.values()) {
            tempBlob.close();
        }
    }
}

