/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.npm.internal;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.InvalidContentException;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.npm.internal.NpmFacetUtils;
import org.sonatype.nexus.repository.npm.internal.NpmPublishParser;
import org.sonatype.nexus.repository.npm.internal.NpmPublishRequest;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.TempBlob;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.security.SecuritySystem;
import org.sonatype.nexus.security.user.User;
import org.sonatype.nexus.security.user.UserNotFoundException;

@Named
@Singleton
public class NpmRequestParser
extends ComponentSupport {
    private static final JsonFactory jsonFactory = new JsonFactory();
    private final SecuritySystem securitySystem;

    @Inject
    public NpmRequestParser(SecuritySystem securitySystem) {
        this.securitySystem = securitySystem;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NpmPublishRequest parsePublish(Repository repository, Payload payload) throws IOException {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)payload);
        StorageFacet storageFacet = (StorageFacet)repository.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            NpmPublishRequest npmPublishRequest;
            block9: {
                TempBlob tempBlob = storageFacet.createTempBlob(payload, NpmFacetUtils.HASH_ALGORITHMS);
                try {
                    npmPublishRequest = this.parseNpmPublish(storageFacet, tempBlob, StandardCharsets.UTF_8);
                    if (tempBlob == null) break block9;
                }
                catch (JsonParseException e) {
                    if (!e.getMessage().contains("Invalid UTF-8")) throw new InvalidContentException("Invalid JSON input", (Throwable)e);
                    NpmPublishRequest npmPublishRequest2 = this.parseNpmPublish(storageFacet, tempBlob, StandardCharsets.ISO_8859_1);
                    return npmPublishRequest2;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                tempBlob.close();
            }
            return npmPublishRequest;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    /*
     * Exception decompiling
     */
    @VisibleForTesting
    NpmPublishRequest parseNpmPublish(StorageFacet storageFacet, TempBlob tempBlob, Charset charset) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    private String getUserId() {
        try {
            User currentUser = this.securitySystem.currentUser();
            return currentUser == null ? null : currentUser.getUserId();
        }
        catch (UserNotFoundException userNotFoundException) {
            this.log.debug("No user found, no name replacement will occur");
            return null;
        }
    }

    @VisibleForTesting
    NpmPublishParser npmPublishParserFor(JsonParser jsonParser, StorageFacet storageFacet) {
        return new NpmPublishParser(jsonParser, storageFacet, NpmFacetUtils.HASH_ALGORITHMS);
    }
}

