/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.npm.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.npm.internal.NpmJsonUtils;
import org.sonatype.nexus.repository.npm.internal.NpmPackageId;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.Status;
import org.sonatype.nexus.repository.view.payloads.BytesPayload;

public final class NpmResponses {
    private static final Payload successPayload = NpmResponses.statusPayload(true, null);

    private NpmResponses() {
    }

    private static Payload statusPayload(boolean success, @Nullable String error) {
        NestedAttributesMap errorObject = new NestedAttributesMap("error", (Map)Maps.newHashMap());
        errorObject.set("success", (Object)success);
        if (error != null) {
            errorObject.set("error", (Object)error);
        }
        return new BytesPayload(NpmJsonUtils.bytes(errorObject), "application/json");
    }

    @Nonnull
    static Response ok() {
        return HttpResponses.ok((Payload)successPayload);
    }

    @Nonnull
    static Response ok(@Nonnull Payload payload) {
        return HttpResponses.ok((Payload)((Payload)Preconditions.checkNotNull((Object)payload)));
    }

    @Nonnull
    static Response notFound(@Nullable String message) {
        return new Response.Builder().status(Status.failure((int)404, (String)"Not Found")).payload(NpmResponses.statusPayload(false, message)).build();
    }

    @Nonnull
    static Response packageNotFound(NpmPackageId packageId) {
        Preconditions.checkNotNull((Object)packageId);
        return NpmResponses.notFound("Package '" + packageId + "' not found");
    }

    @Nonnull
    static Response tarballNotFound(NpmPackageId packageId, String tarballName) {
        Preconditions.checkNotNull((Object)packageId);
        Preconditions.checkNotNull((Object)tarballName);
        return NpmResponses.notFound("Tarball '" + tarballName + "' in package '" + packageId + "' not found");
    }

    @Nonnull
    static Response badRequest(@Nullable String message) {
        return new Response.Builder().status(Status.failure((int)400)).payload(NpmResponses.statusPayload(false, message)).build();
    }

    @Nonnull
    static Response badCredentials(@Nullable String message) {
        return new Response.Builder().status(Status.failure((int)401)).payload(NpmResponses.statusPayload(false, message)).build();
    }
}

