/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.npm.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.npm.internal.NpmFacetUtils;
import org.sonatype.nexus.repository.npm.internal.NpmJsonUtils;
import org.sonatype.nexus.repository.npm.internal.NpmResponses;
import org.sonatype.nexus.repository.npm.internal.NpmTokenFacet;
import org.sonatype.nexus.repository.npm.internal.security.NpmTokenManager;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.TempBlob;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.payloads.BytesPayload;

@Named
public class NpmTokenFacetImpl
extends FacetSupport
implements NpmTokenFacet {
    private final NpmTokenManager npmTokenManager;

    @Inject
    public NpmTokenFacetImpl(NpmTokenManager npmTokenManager) {
        this.npmTokenManager = (NpmTokenManager)((Object)Preconditions.checkNotNull((Object)((Object)npmTokenManager)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Response login(Context context) {
        Payload payload = context.getRequest().getPayload();
        if (payload == null) {
            return NpmResponses.badRequest("Missing body");
        }
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                Response response;
                TempBlob tempBlob = storageFacet.createTempBlob(payload, NpmFacetUtils.HASH_ALGORITHMS);
                try {
                    NestedAttributesMap request = NpmJsonUtils.parse((Supplier<InputStream>)tempBlob);
                    String token = this.npmTokenManager.login((String)request.get("name", String.class), (String)request.get("password", String.class));
                    if (token != null) {
                        NestedAttributesMap response2 = new NestedAttributesMap("response", (Map)Maps.newHashMap());
                        response2.set("ok", (Object)Boolean.TRUE.toString());
                        response2.set("rev", (Object)"_we_dont_use_revs_any_more");
                        response2.set("id", (Object)"org.couchdb.user:undefined");
                        response2.set("token", (Object)token);
                        response = HttpResponses.created((Payload)new BytesPayload(NpmJsonUtils.bytes(response2), "application/json"));
                        return response;
                    }
                    return NpmResponses.badCredentials("Bad username or password");
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    if (tempBlob == null) return response;
                    tempBlob.close();
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Response logout(Context context) {
        if (this.npmTokenManager.logout()) {
            NestedAttributesMap response = new NestedAttributesMap("response", (Map)Maps.newHashMap());
            response.set("ok", (Object)Boolean.TRUE.toString());
            return NpmResponses.ok((Payload)new BytesPayload(NpmJsonUtils.bytes(response), "application/json"));
        }
        return NpmResponses.notFound("Token not found");
    }
}

