/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.npm.internal.search.legacy;

import com.google.common.base.Supplier;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.npm.internal.NpmFacetUtils;
import org.sonatype.nexus.repository.npm.internal.search.legacy.NpmSearchIndexFacet;
import org.sonatype.nexus.repository.npm.internal.search.legacy.NpmSearchIndexFilter;
import org.sonatype.nexus.repository.npm.internal.search.legacy.NpmSearchIndexInvalidatedEvent;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalDeleteBlob;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.transaction.UnitOfWork;

@Deprecated
public abstract class NpmSearchIndexFacetCaching
extends FacetSupport
implements NpmSearchIndexFacet {
    private final EventManager eventManager;

    protected NpmSearchIndexFacetCaching(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    @Override
    @Nonnull
    public Content searchIndex(@Nullable DateTime since) throws IOException {
        Content searchIndex = this.getCachedSearchIndex();
        if (searchIndex == null) {
            searchIndex = this.getSearchIndex();
        }
        return NpmSearchIndexFilter.filterModifiedSince(searchIndex, since);
    }

    @Nullable
    @TransactionalTouchBlob
    protected Content getCachedSearchIndex() throws IOException {
        return this.getSearchIndex(true);
    }

    @TransactionalStoreBlob
    protected Content getSearchIndex() throws IOException {
        return this.getSearchIndex(false);
    }

    @Nullable
    private Content getSearchIndex(boolean fromCacheOnly) throws IOException {
        Bucket bucket;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = NpmFacetUtils.findRepositoryRootAsset(tx, bucket = tx.findBucket(this.getRepository()));
        if (asset == null) {
            if (fromCacheOnly) {
                return null;
            }
            this.log.debug("Building npm index for {}", (Object)this.getRepository().getName());
            asset = (Asset)tx.createAsset(bucket, this.getRepository().getFormat()).name("-/all");
            Path path = Files.createTempFile("npm-searchIndex", "json", new FileAttribute[0]);
            try {
                Content content = this.buildIndex(tx, path);
                Content content2 = NpmFacetUtils.saveRepositoryRoot(tx, asset, (Supplier<InputStream>)((Supplier)() -> {
                    try {
                        return content.openInputStream();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }), content);
                return content2;
            }
            finally {
                Files.delete(path);
            }
        }
        if (asset.markAsDownloaded()) {
            tx.saveAsset(asset);
        }
        return NpmFacetUtils.toContent(asset, tx.requireBlob(asset.requireBlobRef()));
    }

    @Override
    public void invalidateCachedSearchIndex() {
        UnitOfWork.begin((Supplier)((StorageFacet)this.getRepository().facet(StorageFacet.class)).txSupplier());
        try {
            try {
                this.deleteAsset();
            }
            catch (IOException e) {
                this.log.warn("Could not invalidate cached search index for {}", (Object)this.getRepository().getName(), (Object)e);
                UnitOfWork.end();
            }
        }
        finally {
            UnitOfWork.end();
        }
    }

    @TransactionalDeleteBlob
    protected void deleteAsset() throws IOException {
        this.log.debug("Invalidating cached npm index of {}", (Object)this.getRepository().getName());
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = NpmFacetUtils.findRepositoryRootAsset(tx, tx.findBucket(this.getRepository()));
        if (asset == null) {
            return;
        }
        tx.deleteAsset(asset);
        this.eventManager.post((Object)new NpmSearchIndexInvalidatedEvent(this.getRepository()));
    }

    @Nonnull
    protected abstract Content buildIndex(StorageTx var1, Path var2) throws IOException;
}

