/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.npm.internal.search.legacy;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.entity.EntityBatchEvent;
import org.sonatype.nexus.common.entity.EntityEvent;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.event.EventHelper;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.npm.internal.search.legacy.NpmSearchIndexFacet;
import org.sonatype.nexus.repository.storage.AssetEvent;

@Deprecated
@Named
@Singleton
public class NpmSearchIndexSubscriber
extends ComponentSupport
implements EventAware,
EventAware.Asynchronous {
    private final RepositoryManager repositoryManager;

    @Inject
    public NpmSearchIndexSubscriber(RepositoryManager repositoryManager) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(EntityBatchEvent batchEvent) {
        if (!EventHelper.isReplicating()) {
            for (EntityEvent event : batchEvent.getEvents()) {
                Repository npmAssetRepository = this.filterNpmAssetRepository(event);
                if (npmAssetRepository == null) continue;
                this.invalidateCachedSearchIndex(npmAssetRepository);
            }
        }
    }

    @Nullable
    private Repository filterNpmAssetRepository(EntityEvent entityEvent) {
        AssetEvent assetEvent;
        if (entityEvent instanceof AssetEvent && (assetEvent = (AssetEvent)entityEvent).getComponentId() == null && !"-/all".equals(assetEvent.getAsset().name())) {
            return this.findNpmRepository(assetEvent.getRepositoryName());
        }
        return null;
    }

    @Nullable
    private Repository findNpmRepository(String repositoryName) {
        Repository repository = this.repositoryManager.get(repositoryName);
        if (repository != null && "npm".equals(repository.getFormat().getValue())) {
            return repository;
        }
        return null;
    }

    private void invalidateCachedSearchIndex(Repository repository) {
        ((NpmSearchIndexFacet)repository.facet(NpmSearchIndexFacet.class)).invalidateCachedSearchIndex();
    }
}

