/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.npm.internal.search.v1;

import com.google.common.base.Strings;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.view.Parameters;

@Named
@Singleton
public class NpmSearchParameterExtractor
extends ComponentSupport {
    private static final String WILDCARD = "*";

    public String extractText(Parameters parameters) {
        String textParameter = Strings.nullToEmpty((String)parameters.get("text")).trim();
        if (!textParameter.isEmpty() && !(textParameter = textParameter.replaceAll("keywords:", "assets.attributes.npm.keywords:").replaceAll("author:", "assets.attributes.npm.author:").replaceAll("maintainer:", "assets.attributes.npm.author:").replaceAll("is:", "assets.attributes.npm.tagged_is:").replaceAll("not:", "assets.attributes.npm.tagged_not:").replaceAll("scope:", "assets.attributes.npm.scope:")).contains(":")) {
            textParameter = WILDCARD + textParameter + WILDCARD;
        }
        return textParameter;
    }

    public int extractSize(Parameters parameters) {
        int size = 20;
        String sizeParameter = Strings.nullToEmpty((String)parameters.get("size")).trim();
        if (!sizeParameter.isEmpty()) {
            try {
                size = Integer.parseInt(sizeParameter);
            }
            catch (NumberFormatException e) {
                this.log.debug("Invalid size encountered in search parameters {}, using default", (Object)parameters, (Object)e);
            }
            if (size < 1) {
                size = 1;
            } else if (size > 250) {
                size = 250;
            }
        }
        return size;
    }

    public int extractFrom(Parameters parameters) {
        int from = 0;
        String fromParameter = Strings.nullToEmpty((String)parameters.get("from")).trim();
        if (!fromParameter.isEmpty()) {
            try {
                from = Integer.parseInt(fromParameter);
            }
            catch (NumberFormatException e) {
                this.log.debug("Invalid from encountered in search parameters {}, using default", (Object)parameters, (Object)e);
            }
            if (from < 0) {
                from = 0;
            }
        }
        return from;
    }
}

