/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.npm.internal.search.v1;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.metrics.tophits.TopHits;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.npm.internal.search.v1.NpmSearchHitExtractor;
import org.sonatype.nexus.repository.npm.internal.search.v1.NpmSearchResponse;
import org.sonatype.nexus.repository.npm.internal.search.v1.NpmSearchResponseObject;
import org.sonatype.nexus.repository.npm.internal.search.v1.NpmSearchResponsePackage;
import org.sonatype.nexus.repository.npm.internal.search.v1.NpmSearchResponsePackageLinks;
import org.sonatype.nexus.repository.npm.internal.search.v1.NpmSearchResponsePerson;
import org.sonatype.nexus.repository.npm.internal.search.v1.NpmSearchResponseScore;
import org.sonatype.nexus.repository.npm.internal.search.v1.NpmSearchResponseScoreDetail;

@Named
@Singleton
public class NpmSearchResponseFactory
extends ComponentSupport {
    private static final String SEARCH_RESPONSE_PACKAGE_DATE_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static final String SEARCH_RESPONSE_DATE_PATTERN = "EEE MMM dd yyyy HH:mm:ss 'GMT'Z '('z')'";
    private static final DateTimeFormatter SEARCH_RESPONSE_PACKAGE_DATE_FORMAT = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private static final DateTimeFormatter SEARCH_RESPONSE_DATE_FORMAT = DateTimeFormat.forPattern((String)"EEE MMM dd yyyy HH:mm:ss 'GMT'Z '('z')'");
    private static final Double DEFAULT_SCORE = 0.0;
    private final NpmSearchHitExtractor npmSearchHitExtractor;

    @Inject
    public NpmSearchResponseFactory(NpmSearchHitExtractor npmSearchHitExtractor) {
        this.npmSearchHitExtractor = (NpmSearchHitExtractor)((Object)Preconditions.checkNotNull((Object)((Object)npmSearchHitExtractor)));
    }

    public NpmSearchResponse buildEmptyResponse() {
        NpmSearchResponse response = new NpmSearchResponse();
        response.setObjects(Collections.emptyList());
        response.setTime(this.formatSearchResponseDate(DateTime.now()));
        response.setTotal(0);
        return response;
    }

    public NpmSearchResponse buildResponseForResults(List<Terms.Bucket> buckets, int size, int from) {
        List<NpmSearchResponseObject> objects = buckets.stream().map(bucket -> (TopHits)bucket.getAggregations().get("versions")).map(TopHits::getHits).map(searchHits -> searchHits.getAt(0)).map(this::buildSearchResponseObject).skip(from).limit(size).collect(Collectors.toList());
        return this.buildResponseForObjects(objects);
    }

    public NpmSearchResponse buildResponseForObjects(List<NpmSearchResponseObject> objects) {
        NpmSearchResponse response = new NpmSearchResponse();
        response.setObjects(objects);
        response.setTime(this.formatSearchResponseDate(DateTime.now()));
        response.setTotal(objects.size());
        return response;
    }

    private NpmSearchResponseObject buildSearchResponseObject(SearchHit searchHit) {
        NpmSearchResponsePerson person = this.buildPerson(searchHit);
        NpmSearchResponseScore score = this.buildPackageScore();
        NpmSearchResponsePackageLinks links = this.buildPackageLinks(searchHit);
        NpmSearchResponsePackage searchPackage = new NpmSearchResponsePackage();
        searchPackage.setDate(this.formatSearchResponsePackageDate(this.npmSearchHitExtractor.extractLastModified(searchHit)));
        searchPackage.setName(this.npmSearchHitExtractor.extractName(searchHit));
        searchPackage.setVersion(this.npmSearchHitExtractor.extractVersion(searchHit));
        searchPackage.setDescription(this.npmSearchHitExtractor.extractDescription(searchHit));
        searchPackage.setKeywords(this.npmSearchHitExtractor.extractKeywords(searchHit));
        searchPackage.setPublisher(person);
        searchPackage.setMaintainers(person == null ? Collections.emptyList() : Collections.singletonList(person));
        searchPackage.setLinks(links);
        NpmSearchResponseObject searchObject = new NpmSearchResponseObject();
        searchObject.setPackageEntry(searchPackage);
        searchObject.setSearchScore(Double.valueOf(searchHit.getScore()));
        searchObject.setScore(score);
        return searchObject;
    }

    private NpmSearchResponsePackageLinks buildPackageLinks(SearchHit searchHit) {
        NpmSearchResponsePackageLinks links = new NpmSearchResponsePackageLinks();
        links.setBugs(this.npmSearchHitExtractor.extractBugsUrl(searchHit));
        links.setHomepage(this.npmSearchHitExtractor.extractHomepage(searchHit));
        links.setRepository(this.npmSearchHitExtractor.extractRepositoryUrl(searchHit));
        return links;
    }

    private NpmSearchResponseScore buildPackageScore() {
        NpmSearchResponseScoreDetail scoreDetail = new NpmSearchResponseScoreDetail();
        scoreDetail.setMaintenance(DEFAULT_SCORE);
        scoreDetail.setPopularity(DEFAULT_SCORE);
        scoreDetail.setQuality(DEFAULT_SCORE);
        NpmSearchResponseScore score = new NpmSearchResponseScore();
        score.setFinalScore(DEFAULT_SCORE);
        score.setDetail(scoreDetail);
        return score;
    }

    @Nullable
    private NpmSearchResponsePerson buildPerson(SearchHit searchHit) {
        String username = this.npmSearchHitExtractor.extractAuthorName(searchHit);
        String email = this.npmSearchHitExtractor.extractAuthorEmail(searchHit);
        if (username == null && email == null) {
            return null;
        }
        NpmSearchResponsePerson person = new NpmSearchResponsePerson();
        person.setUsername(username);
        person.setEmail(email);
        return person;
    }

    private String formatSearchResponsePackageDate(DateTime dateTime) {
        return SEARCH_RESPONSE_PACKAGE_DATE_FORMAT.print((ReadableInstant)dateTime.toDateTime(DateTimeZone.UTC));
    }

    private String formatSearchResponseDate(DateTime dateTime) {
        return SEARCH_RESPONSE_DATE_FORMAT.print((ReadableInstant)dateTime.toDateTime(DateTimeZone.UTC));
    }
}

