/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.npm.internal.tasks;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.collect.ImmutableNestedAttributesMap;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.attributes.AttributesFacet;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskInfo;
import org.sonatype.nexus.scheduling.TaskScheduler;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.TASKS)
@Singleton
public class ReindexNpmRepositoryManager
extends StateGuardLifecycleSupport {
    private final TaskScheduler taskScheduler;
    private final RepositoryManager repositoryManager;
    private final boolean enabled;

    @Inject
    public ReindexNpmRepositoryManager(TaskScheduler taskScheduler, RepositoryManager repositoryManager, @Named(value="${nexus.npm.reindexOnStartup.enabled:-true}") boolean enabled) {
        this.taskScheduler = (TaskScheduler)Preconditions.checkNotNull((Object)taskScheduler);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.enabled = enabled;
    }

    protected void doStart() {
        if (!this.enabled) {
            return;
        }
        try {
            for (Repository repository : this.repositoryManager.browse()) {
                if (!this.isUnprocessedNpmRepository(repository) || this.hasRunningTask(repository)) continue;
                this.runReindexTaskForRepository(repository);
            }
        }
        catch (Exception e) {
            this.log.error("Failed to determine if any npm repositories needed to be reindexed", (Throwable)e);
        }
    }

    private void runReindexTaskForRepository(Repository repository) {
        TaskConfiguration configuration = this.taskScheduler.createTaskConfigurationInstance("repository.npm.reindex");
        configuration.setString("repositoryName", repository.getName());
        configuration.setName("Reindex npm repository - (" + repository.getName() + ")");
        this.taskScheduler.submit(configuration);
    }

    private boolean isUnprocessedNpmRepository(Repository repository) {
        AttributesFacet attributesFacet = (AttributesFacet)repository.facet(AttributesFacet.class);
        ImmutableNestedAttributesMap attributes = attributesFacet.getAttributes();
        return Boolean.TRUE.equals(attributes.get("npm_v1_search_unsupported"));
    }

    private boolean hasRunningTask(Repository repository) {
        for (TaskInfo taskInfo : this.taskScheduler.listsTasks()) {
            TaskConfiguration taskConfiguration = taskInfo.getConfiguration();
            String typeId = taskConfiguration.getTypeId();
            String repositoryName = taskConfiguration.getString("repositoryName");
            if (!"repository.npm.reindex".equals(typeId) || !repository.getName().equals(repositoryName) || !TaskInfo.State.RUNNING.equals((Object)taskInfo.getCurrentState().getState())) continue;
            return true;
        }
        return false;
    }
}

