/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.npm.internal.tasks;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.RepositoryTaskSupport;
import org.sonatype.nexus.repository.attributes.AttributesFacet;
import org.sonatype.nexus.repository.npm.internal.NpmAttributes;
import org.sonatype.nexus.repository.npm.internal.NpmFormatAttributesExtractor;
import org.sonatype.nexus.repository.npm.internal.NpmPackageParser;
import org.sonatype.nexus.repository.npm.internal.search.v1.NpmSearchFacet;
import org.sonatype.nexus.repository.search.SearchFacet;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetEntityAdapter;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalStoreMetadata;
import org.sonatype.nexus.scheduling.Cancelable;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class ReindexNpmRepositoryTask
extends RepositoryTaskSupport
implements Cancelable {
    public static final String NPM_V1_SEARCH_UNSUPPORTED = "npm_v1_search_unsupported";
    private static final String ASSETS_WHERE = "@RID > :rid";
    private static final String ASSETS_SUFFIX = "ORDER BY @RID LIMIT :limit";
    private static final int BATCH_SIZE = 100;
    private static final String BEGINNING_ID = "#-1:-1";
    private final NpmPackageParser npmPackageParser;
    private final AssetEntityAdapter assetEntityAdapter;

    @Inject
    public ReindexNpmRepositoryTask(NpmPackageParser npmPackageParser, AssetEntityAdapter assetEntityAdapter) {
        this.npmPackageParser = (NpmPackageParser)((Object)Preconditions.checkNotNull((Object)((Object)npmPackageParser)));
        this.assetEntityAdapter = (AssetEntityAdapter)Preconditions.checkNotNull((Object)assetEntityAdapter);
    }

    protected void execute(Repository repository) {
        SearchFacet searchFacet = (SearchFacet)repository.facet(SearchFacet.class);
        searchFacet.rebuildIndex();
        String lastId = BEGINNING_ID;
        while (lastId != null && !this.isCanceled()) {
            try {
                lastId = this.processBatch(repository, lastId);
            }
            catch (Exception e) {
                Throwables.propagateIfPossible((Throwable)e, RuntimeException.class);
                throw new RuntimeException(e);
            }
        }
        ((AttributesFacet)repository.facet(AttributesFacet.class)).modifyAttributes(attributes -> {
            Object object = attributes.remove(NPM_V1_SEARCH_UNSUPPORTED);
        });
    }

    @Nullable
    private String processBatch(Repository repository, String lastId) throws Exception {
        return (String)TransactionalStoreMetadata.operation.withDb(((StorageFacet)repository.facet(StorageFacet.class)).txSupplier()).throwing(Exception.class).call(() -> {
            Iterable<Asset> assets = this.readAssets(repository, lastId);
            return this.updateAssets(repository, assets);
        });
    }

    private Iterable<Asset> readAssets(Repository repository, String lastId) {
        StorageTx storageTx = (StorageTx)UnitOfWork.currentTx();
        ImmutableMap parameters = ImmutableMap.of((Object)"rid", (Object)lastId, (Object)"limit", (Object)100);
        return storageTx.findAssets(ASSETS_WHERE, (Map)parameters, Collections.singletonList(repository), ASSETS_SUFFIX);
    }

    @Nullable
    private String updateAssets(Repository repository, Iterable<Asset> assets) {
        String lastId = null;
        for (Asset asset : assets) {
            lastId = this.assetEntityAdapter.recordIdentity((Entity)asset).toString();
            this.maybeUpdateAsset(repository, asset);
        }
        return lastId;
    }

    private void maybeUpdateAsset(Repository repository, Asset asset) {
        try {
            NpmAttributes.AssetKind assetKind = NpmAttributes.AssetKind.valueOf((String)asset.formatAttributes().get("asset_kind", String.class));
            if (assetKind != NpmAttributes.AssetKind.TARBALL) {
                return;
            }
            StorageTx storageTx = (StorageTx)UnitOfWork.currentTx();
            Blob blob = storageTx.requireBlob(asset.blobRef());
            Map<String, Object> formatAttributes = this.npmPackageParser.parsePackageJson(() -> ((Blob)blob).getInputStream());
            if (formatAttributes.isEmpty()) {
                this.log.warn("No format attributes found in package.json for npm asset {} in repository {}, will not be searchable", (Object)asset.name(), (Object)repository.getName());
            } else {
                NpmFormatAttributesExtractor formatAttributesExtractor = new NpmFormatAttributesExtractor(formatAttributes);
                formatAttributesExtractor.copyFormatAttributes(asset);
                storageTx.saveAsset(asset);
            }
        }
        catch (Exception e) {
            this.log.error("Error occurred while reindexing npm asset {} in repository {}, will not be searchable", new Object[]{asset.name(), repository.getName(), e});
        }
    }

    protected boolean appliesTo(Repository repository) {
        return repository.optionalFacet(NpmSearchFacet.class).isPresent();
    }

    public String getMessage() {
        return "Reindexing npm format attributes of " + this.getRepositoryField();
    }
}

