/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.npm.upgrade;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.upgrade.DependsOn;
import org.sonatype.nexus.common.upgrade.Upgrades;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.DatabaseUpgradeSupport;

@Named
@Singleton
@Upgrades(model="component", from="1.8", to="1.9")
@DependsOn(model="config", version="1.5")
public class ComponentDatabaseUpgrade_1_9
extends DatabaseUpgradeSupport {
    private static final String SELECT_NPM_REPOSITORIES = "select from repository where recipe_name in ['npm-hosted', 'npm-proxy']";
    private static final String UPDATE_BUCKET_ATTRIBUTES = "update bucket set attributes.npm_v1_search_unsupported = true where repository_name in ?";
    private static final String P_REPOSITORY_NAME = "repository_name";
    private final Provider<DatabaseInstance> configDatabaseInstance;
    private final Provider<DatabaseInstance> componentDatabaseInstance;

    @Inject
    public ComponentDatabaseUpgrade_1_9(@Named(value="config") Provider<DatabaseInstance> configDatabaseInstance, @Named(value="component") Provider<DatabaseInstance> componentDatabaseInstance) {
        this.configDatabaseInstance = (Provider)Preconditions.checkNotNull(configDatabaseInstance);
        this.componentDatabaseInstance = (Provider)Preconditions.checkNotNull(componentDatabaseInstance);
    }

    public void apply() throws Exception {
        if (ComponentDatabaseUpgrade_1_9.hasSchemaClass(this.configDatabaseInstance, (String)"repository") && ComponentDatabaseUpgrade_1_9.hasSchemaClass(this.componentDatabaseInstance, (String)"bucket")) {
            this.markNpmRepositoriesWithoutV1SearchIndexing();
        }
    }

    private void markNpmRepositoriesWithoutV1SearchIndexing() {
        List npmRepositoryNames;
        Throwable throwable = null;
        Object var3_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.configDatabaseInstance.get()).connect();){
            npmRepositoryNames = db.query((OQuery)new OSQLSynchQuery(SELECT_NPM_REPOSITORIES), new Object[0]).stream().map(d -> (String)d.field(P_REPOSITORY_NAME)).collect(Collectors.toList());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (!npmRepositoryNames.isEmpty()) {
            int updates;
            this.log.info("Marking existing npm repositories as not supporting v1 search ({}).", npmRepositoryNames);
            OCommandSQL updateBucketsCommand = new OCommandSQL(UPDATE_BUCKET_ATTRIBUTES);
            Throwable throwable3 = null;
            Object var5_9 = null;
            try (ODatabaseDocumentTx db = ((DatabaseInstance)this.componentDatabaseInstance.get()).connect();){
                updates = (Integer)db.command((OCommandRequest)updateBucketsCommand).execute(new Object[]{npmRepositoryNames});
            }
            catch (Throwable throwable4) {
                if (throwable3 == null) {
                    throwable3 = throwable4;
                } else if (throwable3 != throwable4) {
                    throwable3.addSuppressed(throwable4);
                }
                throw throwable3;
            }
            this.log.info("Marked {} existing npm repositories as not supporting v1 search.", (Object)updates);
        }
    }
}

