/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.sonatype.nexus.blobstore.api.BlobStoreMetrics;
import org.sonatype.nexus.common.math.Math2;

public class AccumulatingBlobStoreMetrics
implements BlobStoreMetrics {
    private long blobCount;
    private long totalSize;
    private final Map<String, Long> availableSpaceByFileStore;
    private final boolean unlimited;

    public AccumulatingBlobStoreMetrics(long blobCount, long totalSize, Map<String, Long> availableSpaceByFileStore, boolean unlimited) {
        this.blobCount = blobCount;
        this.totalSize = totalSize;
        this.availableSpaceByFileStore = (Map)Preconditions.checkNotNull(availableSpaceByFileStore);
        this.unlimited = unlimited;
    }

    public long getBlobCount() {
        return this.blobCount;
    }

    public void addBlobCount(long blobCount) {
        this.blobCount += blobCount;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public void addTotalSize(long totalSize) {
        this.totalSize += totalSize;
    }

    public long getAvailableSpace() {
        return this.availableSpaceByFileStore.values().stream().reduce(Math2::addClamped).orElse(0L);
    }

    public boolean isUnlimited() {
        return this.unlimited;
    }

    public Map<String, Long> getAvailableSpaceByFileStore() {
        return this.availableSpaceByFileStore;
    }
}

