/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.sonatype.nexus.blobstore.api.BlobAttributes;
import org.sonatype.nexus.blobstore.api.BlobMetrics;

public abstract class BlobAttributesSupport<T extends Properties>
implements BlobAttributes {
    private Map<String, String> headers;
    private BlobMetrics metrics;
    private boolean deleted = false;
    private String deletedReason;
    protected final T propertiesFile;

    protected BlobAttributesSupport(T propertiesFile, @Nullable Map<String, String> headers, @Nullable BlobMetrics metrics) {
        this.propertiesFile = (Properties)Preconditions.checkNotNull(propertiesFile);
        this.headers = headers;
        this.metrics = metrics;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public BlobMetrics getMetrics() {
        return this.metrics;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public void setDeletedReason(String deletedReason) {
        this.deletedReason = deletedReason;
    }

    public String getDeletedReason() {
        return this.deletedReason != null ? this.deletedReason : "No reason supplied";
    }

    public Properties getProperties() {
        return new Properties((Properties)this.propertiesFile);
    }

    public void updateFrom(BlobAttributes blobAttributes) {
        this.headers = blobAttributes.getHeaders();
        this.metrics = blobAttributes.getMetrics();
        this.deleted = blobAttributes.isDeleted();
        this.deletedReason = blobAttributes.getDeletedReason();
    }

    protected void readFrom(Properties properties) {
        this.headers = new HashMap<String, String>();
        for (Map.Entry<Object, Object> property : properties.entrySet()) {
            String key = (String)property.getKey();
            if (!key.startsWith("@")) continue;
            this.headers.put(key.substring("@".length()), String.valueOf(property.getValue()));
        }
        this.metrics = new BlobMetrics(new DateTime(Long.parseLong(properties.getProperty("creationTime"))), properties.getProperty("sha1"), Long.parseLong(properties.getProperty("size")));
        this.deleted = properties.containsKey("deleted");
        this.deletedReason = properties.getProperty("deletedReason");
    }

    protected void writeTo(Properties properties) {
        for (Map.Entry<String, String> header : this.getHeaders().entrySet()) {
            properties.put("@" + header.getKey(), header.getValue());
        }
        BlobMetrics blobMetrics = this.getMetrics();
        properties.setProperty("sha1", blobMetrics.getSha1Hash());
        properties.setProperty("size", Long.toString(blobMetrics.getContentSize()));
        properties.setProperty("creationTime", Long.toString(blobMetrics.getCreationTime().getMillis()));
        if (this.deleted) {
            properties.put("deleted", Boolean.toString(this.deleted));
            properties.put("deletedReason", this.getDeletedReason());
        } else {
            properties.remove("deleted");
            properties.remove("deletedReason");
        }
    }

    public String toString() {
        return ((Properties)this.propertiesFile).toString();
    }
}

