/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.sonatype.nexus.blobstore.AccumulatingBlobStoreMetrics;
import org.sonatype.nexus.blobstore.PeriodicJobService;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreMetrics;
import org.sonatype.nexus.blobstore.quota.BlobStoreQuotaService;
import org.sonatype.nexus.blobstore.quota.BlobStoreQuotaSupport;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.common.property.ImplicitSourcePropertiesFile;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;

public abstract class BlobStoreMetricsStoreSupport<T extends ImplicitSourcePropertiesFile>
extends StateGuardLifecycleSupport {
    private static final int METRICS_LOADING_DELAY_MILLIS = 200;
    public static final int MAXIMUM_TRIES = 3;
    @VisibleForTesting
    public static final String METRICS_FILENAME = "metrics.properties";
    @VisibleForTesting
    public static final String TOTAL_SIZE_PROP_NAME = "totalSize";
    @VisibleForTesting
    public static final String BLOB_COUNT_PROP_NAME = "blobCount";
    private static final int METRICS_FLUSH_PERIOD_SECONDS = 2;
    protected AtomicLong blobCount;
    protected AtomicLong totalSize;
    protected AtomicBoolean dirty;
    protected BlobStore blobStore;
    protected PeriodicJobService.PeriodicJob quotaCheckingJob;
    protected final NodeAccess nodeAccess;
    protected T properties;
    protected final PeriodicJobService jobService;
    protected PeriodicJobService.PeriodicJob metricsWritingJob;
    protected final BlobStoreQuotaService quotaService;
    protected final int quotaCheckInterval;

    public BlobStoreMetricsStoreSupport(NodeAccess nodeAccess, PeriodicJobService jobService, BlobStoreQuotaService quotaService, int quotaCheckInterval) {
        this.nodeAccess = (NodeAccess)Preconditions.checkNotNull((Object)nodeAccess);
        this.jobService = (PeriodicJobService)Preconditions.checkNotNull((Object)jobService);
        this.quotaService = (BlobStoreQuotaService)Preconditions.checkNotNull((Object)quotaService);
        Preconditions.checkArgument((quotaCheckInterval > 0 ? 1 : 0) != 0);
        this.quotaCheckInterval = quotaCheckInterval;
    }

    protected void doStart() throws Exception {
        this.blobCount = new AtomicLong();
        this.totalSize = new AtomicLong();
        this.dirty = new AtomicBoolean();
        this.properties = this.getProperties();
        if (this.properties.exists()) {
            this.log.info("Loading blob store metrics file {}", this.properties);
            this.properties.load();
            this.readProperties();
        } else {
            this.log.info("Blob store metrics file {} not found - initializing at zero.", this.properties);
            this.updateProperties();
            this.properties.store();
        }
        this.jobService.startUsing();
        this.metricsWritingJob = this.jobService.schedule(() -> {
            try {
                if (this.dirty.compareAndSet(true, false)) {
                    this.updateProperties();
                    this.log.trace("Writing blob store metrics to {}", this.properties);
                    this.properties.store();
                }
            }
            catch (Exception e) {
                this.log.error("Cannot write blob store metrics", (Throwable)e);
            }
        }, 2);
        this.quotaCheckingJob = this.jobService.schedule(BlobStoreQuotaSupport.createQuotaCheckJob(this.blobStore, this.quotaService, this.log), this.quotaCheckInterval);
    }

    protected void doStop() throws Exception {
        this.blobStore = null;
        this.metricsWritingJob.cancel();
        this.metricsWritingJob = null;
        this.quotaCheckingJob.cancel();
        this.quotaCheckingJob = null;
        this.jobService.stopUsing();
        this.blobCount = null;
        this.totalSize = null;
        this.dirty = null;
        this.properties = null;
    }

    protected abstract T getProperties();

    protected abstract AccumulatingBlobStoreMetrics getAccumulatingBlobStoreMetrics();

    protected abstract Stream<T> backingFiles();

    protected BlobStoreMetrics getCombinedMetrics(Stream<T> blobStoreMetricsFiles) {
        AccumulatingBlobStoreMetrics blobStoreMetrics = this.getAccumulatingBlobStoreMetrics();
        blobStoreMetricsFiles.forEach(metricsFile -> {
            Stream.iterate(1, i -> i + 1).limit(3L).forEach(currentTry -> {
                try {
                    metricsFile.load();
                }
                catch (IOException e) {
                    this.log.debug("Unable to load properties file {}. Try number {} of {}.", new Object[]{metricsFile, currentTry, 3, e});
                    if (currentTry >= 3) {
                        throw new RuntimeException("Failed to load blob store metrics from " + metricsFile, e);
                    }
                    try {
                        TimeUnit.MILLISECONDS.sleep(200L);
                    }
                    catch (InterruptedException e1) {
                        throw new RuntimeException(e1);
                    }
                }
            });
            blobStoreMetrics.addBlobCount(Long.parseLong(metricsFile.getProperty(BLOB_COUNT_PROP_NAME, "0")));
            blobStoreMetrics.addTotalSize(Long.parseLong(metricsFile.getProperty(TOTAL_SIZE_PROP_NAME, "0")));
        });
        return blobStoreMetrics;
    }

    public void setBlobStore(BlobStore blobStore) {
        Preconditions.checkState((this.blobStore == null ? 1 : 0) != 0, (Object)"Do not initialize twice");
        Preconditions.checkNotNull((Object)blobStore);
        this.blobStore = blobStore;
    }

    @Guarded(by={"STARTED"})
    public BlobStoreMetrics getMetrics() {
        return this.getCombinedMetrics(this.backingFiles());
    }

    @Guarded(by={"STARTED"})
    public void recordAddition(long size) {
        this.blobCount.incrementAndGet();
        this.totalSize.addAndGet(size);
        this.dirty.set(true);
    }

    @Guarded(by={"STARTED"})
    public void recordDeletion(long size) {
        this.blobCount.decrementAndGet();
        this.totalSize.addAndGet(-size);
        this.dirty.set(true);
    }

    private void updateProperties() {
        this.properties.setProperty(TOTAL_SIZE_PROP_NAME, this.totalSize.toString());
        this.properties.setProperty(BLOB_COUNT_PROP_NAME, this.blobCount.toString());
    }

    private void readProperties() {
        String count;
        String size = this.properties.getProperty(TOTAL_SIZE_PROP_NAME);
        if (size != null) {
            this.totalSize.set(Long.parseLong(size));
        }
        if ((count = this.properties.getProperty(BLOB_COUNT_PROP_NAME)) != null) {
            this.blobCount.set(Long.parseLong(count));
        }
    }

    public abstract void remove();
}

