/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonatype.nexus.blobstore.AttributesLocation;
import org.sonatype.nexus.blobstore.BlobIdLocationResolver;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobAttributes;
import org.sonatype.nexus.blobstore.api.BlobId;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;
import org.sonatype.nexus.blobstore.api.BlobStoreUsageChecker;
import org.sonatype.nexus.common.log.DryRunPrefix;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;

public abstract class BlobStoreSupport<T extends AttributesLocation>
extends StateGuardLifecycleSupport
implements BlobStore {
    public static final String BLOB_ATTRIBUTE_SUFFIX = ".properties";
    protected final BlobIdLocationResolver blobIdLocationResolver;
    protected final DryRunPrefix dryRunPrefix;
    protected BlobStoreConfiguration blobStoreConfiguration;
    protected static final Pattern UUID_PATTERN = Pattern.compile(".*vol-\\d{2}/chap-\\d{2}/\\b[0-9a-f]{8}\\b-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-\\b[0-9a-f]{12}\\b.properties$", 2);

    public BlobStoreSupport(BlobIdLocationResolver blobIdLocationResolver, DryRunPrefix dryRunPrefix) {
        this.blobIdLocationResolver = (BlobIdLocationResolver)Preconditions.checkNotNull((Object)blobIdLocationResolver);
        this.dryRunPrefix = (DryRunPrefix)Preconditions.checkNotNull((Object)dryRunPrefix);
    }

    protected BlobId getBlobId(Map<String, String> headers, @Nullable BlobId blobId) {
        return Optional.ofNullable(blobId).orElseGet(() -> this.blobIdLocationResolver.fromHeaders(headers));
    }

    private void checkIsWritable() {
        Preconditions.checkState((boolean)this.isWritable(), (Object)"Operation not permitted when blob store is not writable");
    }

    @Guarded(by={"STARTED"})
    public Blob create(InputStream blobData, Map<String, String> headers) {
        return this.create(blobData, headers, null);
    }

    @Guarded(by={"STARTED"})
    public Blob create(InputStream blobData, Map<String, String> headers, @Nullable BlobId blobId) {
        Preconditions.checkNotNull((Object)blobData);
        Preconditions.checkNotNull(headers);
        this.checkIsWritable();
        Preconditions.checkArgument((boolean)headers.containsKey("BlobStore.blob-name"), (String)"Missing header: %s", (Object)"BlobStore.blob-name");
        Preconditions.checkArgument((boolean)headers.containsKey("BlobStore.created-by"), (String)"Missing header: %s", (Object)"BlobStore.created-by");
        return this.doCreate(blobData, headers, blobId);
    }

    protected abstract Blob doCreate(InputStream var1, Map<String, String> var2, @Nullable BlobId var3);

    @Guarded(by={"STARTED"})
    public boolean delete(BlobId blobId, String reason) {
        Preconditions.checkNotNull((Object)blobId);
        return this.doDelete(blobId, reason);
    }

    protected abstract boolean doDelete(BlobId var1, String var2);

    @Guarded(by={"STARTED"})
    public boolean undelete(@Nullable BlobStoreUsageChecker inUseChecker, BlobId blobId, BlobAttributes attributes, boolean isDryRun) {
        Preconditions.checkNotNull((Object)attributes);
        String logPrefix = isDryRun ? this.dryRunPrefix.get() : "";
        Optional<String> blobName = Optional.of(attributes).map(BlobAttributes::getProperties).map(p -> p.getProperty("@BlobStore.blob-name"));
        if (!blobName.isPresent()) {
            this.log.error("Property not present: {}, for blob id: {}, at path: {}", new Object[]{"@BlobStore.blob-name", blobId, this.attributePathString(blobId)});
            return false;
        }
        if (attributes.isDeleted() && inUseChecker != null && inUseChecker.test((BlobStore)this, blobId, blobName.get())) {
            String deletedReason = attributes.getDeletedReason();
            if (!isDryRun) {
                attributes.setDeleted(false);
                attributes.setDeletedReason(null);
                try {
                    this.doUndelete(blobId);
                    attributes.store();
                }
                catch (IOException e) {
                    this.log.error("Error while un-deleting blob id: {}, deleted reason: {}, blob store: {}, blob name: {}", new Object[]{blobId, deletedReason, this.blobStoreConfiguration.getName(), blobName.get(), e});
                }
            }
            this.log.warn("{}Soft-deleted blob still in use, un-deleting blob id: {}, deleted reason: {}, blob store: {}, blob name: {}", new Object[]{logPrefix, blobId, deletedReason, this.blobStoreConfiguration.getName(), blobName.get()});
            return true;
        }
        return false;
    }

    protected abstract String attributePathString(BlobId var1);

    protected void doUndelete(BlobId blobId) {
    }

    @Guarded(by={"STARTED"})
    public boolean deleteHard(BlobId blobId) {
        Preconditions.checkNotNull((Object)blobId);
        return this.doDeleteHard(blobId);
    }

    protected abstract boolean doDeleteHard(BlobId var1);

    @Guarded(by={"STARTED"})
    public synchronized void compact() {
        this.compact(null);
    }

    @Guarded(by={"STARTED"})
    public synchronized void compact(@Nullable BlobStoreUsageChecker inUseChecker) {
        this.doCompact(inUseChecker);
    }

    protected void doCompact(@Nullable BlobStoreUsageChecker inUseChecker) {
    }

    public void init(BlobStoreConfiguration configuration) {
        this.blobStoreConfiguration = configuration;
        this.doInit(this.blobStoreConfiguration);
    }

    protected abstract void doInit(BlobStoreConfiguration var1);

    public BlobStoreConfiguration getBlobStoreConfiguration() {
        return this.blobStoreConfiguration;
    }

    protected abstract BlobAttributes getBlobAttributes(T var1) throws IOException;

    protected String getBlobIdFromAttributeFilePath(T attributeFilePath) {
        if (UUID_PATTERN.matcher(attributeFilePath.getFullPath()).matches()) {
            String filename = attributeFilePath.getFileName();
            return filename.substring(0, filename.length() - BLOB_ATTRIBUTE_SUFFIX.length());
        }
        try {
            BlobAttributes fileBlobAttributes = this.getBlobAttributes(attributeFilePath);
            return this.blobIdLocationResolver.fromHeaders(fileBlobAttributes.getHeaders()).asUniqueString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

