/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.sonatype.goodies.common.Locks;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobId;
import org.sonatype.nexus.blobstore.api.BlobMetrics;

public abstract class BlobSupport
implements Blob {
    private final BlobId blobId;
    private final Lock lock;
    private Map<String, String> headers;
    private BlobMetrics metrics;
    private volatile boolean stale;

    public BlobSupport(BlobId blobId) {
        this.blobId = (BlobId)Preconditions.checkNotNull((Object)blobId);
        this.lock = new ReentrantLock();
        this.stale = true;
    }

    public void refresh(Map<String, String> headers, BlobMetrics metrics) {
        this.headers = (Map)Preconditions.checkNotNull(headers);
        this.metrics = (BlobMetrics)Preconditions.checkNotNull((Object)metrics);
        this.stale = false;
    }

    public void markStale() {
        this.stale = true;
    }

    public boolean isStale() {
        return this.stale;
    }

    public BlobId getId() {
        return this.blobId;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public BlobMetrics getMetrics() {
        return this.metrics;
    }

    public Lock lock() {
        return Locks.lock((Lock)this.lock);
    }
}

