/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore;

import com.google.common.base.Preconditions;
import org.sonatype.nexus.blobstore.LocationStrategySupport;
import org.sonatype.nexus.blobstore.api.BlobId;

public class DirectPathLocationStrategy
extends LocationStrategySupport {
    public static final String DIRECT_PATH_ROOT = "directpath";
    public static final String DIRECT_PATH_PREFIX = "path$";

    @Override
    public String location(BlobId blobId) {
        Preconditions.checkNotNull((Object)blobId);
        Preconditions.checkArgument((!blobId.asUniqueString().contains("..") ? 1 : 0) != 0, (Object)"Traversal not allowed with direct blobs");
        return String.format("%s/%s", DIRECT_PATH_ROOT, blobId.asUniqueString().replace(DIRECT_PATH_PREFIX, ""));
    }
}

