/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore;

import com.google.common.io.BaseEncoding;
import com.google.common.io.CountingInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.sonatype.nexus.blobstore.StreamMetrics;

public class MetricsInputStream
extends FilterInputStream {
    private final MessageDigest messageDigest;
    private final CountingInputStream countingInputStream;
    private static final BaseEncoding HEX = BaseEncoding.base16().lowerCase();

    public MetricsInputStream(InputStream input) {
        this(new CountingInputStream(input), MetricsInputStream.createSha1());
    }

    private MetricsInputStream(CountingInputStream countingStream, MessageDigest messageDigest) {
        super(new DigestInputStream((InputStream)countingStream, messageDigest));
        this.messageDigest = messageDigest;
        this.countingInputStream = countingStream;
    }

    public String getMessageDigest() {
        return HEX.encode(this.messageDigest.digest());
    }

    public long getSize() {
        return this.countingInputStream.getCount();
    }

    public StreamMetrics getMetrics() {
        return new StreamMetrics(this.getSize(), this.getMessageDigest());
    }

    private static MessageDigest createSha1() {
        try {
            return MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

