/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore;

import com.google.common.base.Preconditions;
import org.sonatype.nexus.blobstore.LocationStrategySupport;
import org.sonatype.nexus.blobstore.api.BlobId;

public class VolumeChapterLocationStrategy
extends LocationStrategySupport {
    private static final int TIER_1_MODULO = 43;
    private static final int TIER_2_MODULO = 47;

    @Override
    public String location(BlobId blobId) {
        Preconditions.checkNotNull((Object)blobId);
        return String.format("vol-%02d/chap-%02d/%s", this.tier(blobId, 43), this.tier(blobId, 47), this.escapeFilename(blobId.asUniqueString()));
    }

    private int tier(BlobId blobId, int modulo) {
        return Math.abs(blobId.hashCode() % modulo) + 1;
    }
}

