/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.group.internal;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.validation.ValidationException;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.nexus.blobstore.BlobStoreDescriptorSupport;
import org.sonatype.nexus.blobstore.BlobStoreUtil;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.blobstore.group.BlobStoreGroupConfigurationHelper;
import org.sonatype.nexus.blobstore.group.BlobStoreGroupService;
import org.sonatype.nexus.blobstore.quota.BlobStoreQuotaService;
import org.sonatype.nexus.formfields.ComboboxFormField;
import org.sonatype.nexus.formfields.FormField;
import org.sonatype.nexus.formfields.ItemselectFormField;

@Named(value="Group")
public class BlobStoreGroupDescriptor
extends BlobStoreDescriptorSupport {
    private static final Messages messages = (Messages)I18N.create(Messages.class);
    private final BlobStoreManager blobStoreManager;
    private final BlobStoreUtil blobStoreUtil;
    private final Provider<BlobStoreGroupService> blobStoreGroupService;
    private final ItemselectFormField members;
    private final FormField fillPolicy;

    @Inject
    public BlobStoreGroupDescriptor(BlobStoreManager blobStoreManager, BlobStoreUtil blobStoreUtil, Provider<BlobStoreGroupService> blobStoreGroupService, BlobStoreQuotaService quotaService) {
        super(quotaService);
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
        this.blobStoreUtil = (BlobStoreUtil)Preconditions.checkNotNull((Object)blobStoreUtil);
        this.blobStoreGroupService = (Provider)Preconditions.checkNotNull(blobStoreGroupService);
        this.members = new ItemselectFormField("members", messages.membersLabel(), null, true);
        this.members.setStoreApi("coreui_Blobstore.readGroupable");
        this.members.setIdMapping("name");
        this.members.setButtons(new String[]{"up", "add", "remove", "down"});
        this.members.setFromTitle("Available");
        this.members.setToTitle("Selected");
        this.fillPolicy = new ComboboxFormField("fillPolicy", messages.fillPolicyLabel(), null, true).withStoreApi("coreui_Blobstore.fillPolicies");
    }

    @Override
    public String getName() {
        return messages.name();
    }

    @Override
    public List<FormField> getFormFields() {
        return Arrays.asList(this.members, this.fillPolicy);
    }

    @Override
    public boolean isModifiable() {
        return this.isEnabled();
    }

    @Override
    public void validateConfig(BlobStoreConfiguration config) {
        super.validateConfig(config);
        this.validateEnabled();
        String name = config.getName();
        List<String> memberNames = BlobStoreGroupConfigurationHelper.memberNames(config);
        this.validateNotEmptyOrSelfReferencing(name, memberNames);
        this.validateEligibleMembers(name, memberNames);
        this.validateOnlyEmptyOrNotWritableExistingMembersRemoved(name, memberNames);
    }

    private void validateEnabled() {
        if (!this.isEnabled()) {
            throw new ValidationException("Blob store groups are not enabled");
        }
    }

    private void validateNotEmptyOrSelfReferencing(String name, List<String> memberNames) {
        if (memberNames.isEmpty()) {
            throw new ValidationException("Blob Store '" + name + "' cannot be empty");
        }
        if (memberNames.contains(name)) {
            throw new ValidationException("Blob Store '" + name + "' cannot contain itself");
        }
    }

    private void validateEligibleMembers(String name, List<String> memberNames) {
        for (String memberName : memberNames) {
            BlobStore member = this.blobStoreManager.get(memberName);
            if (!member.isGroupable()) {
                BlobStoreConfiguration memberConfig = member.getBlobStoreConfiguration();
                throw new ValidationException(String.format("Blob Store '%s' is of type '%s' and is not eligible to be a group member", memberName, memberConfig.getType()));
            }
            Predicate<String> sameGroup = name::equals;
            this.blobStoreManager.getParent(memberName).filter(sameGroup.negate()).ifPresent(groupName -> {
                throw new ValidationException(String.format("Blob Store '%s' is already a member of Blob Store Group '%s'", memberName, groupName));
            });
            int repoCount = this.blobStoreUtil.usageCount(memberName);
            if (repoCount <= 0) continue;
            throw new ValidationException(String.format("Blob Store '%s' is set as storage for %s repositories and is not eligible to be a group member", memberName, repoCount));
        }
    }

    private void validateOnlyEmptyOrNotWritableExistingMembersRemoved(String name, List<String> memberNames) {
        BlobStoreConfiguration currentConfiguration;
        BlobStore blobStore = this.blobStoreManager.get(name);
        if (blobStore != null && (currentConfiguration = blobStore.getBlobStoreConfiguration()) != null && currentConfiguration.getType().equals("Group")) {
            for (String existingMemberName : BlobStoreGroupConfigurationHelper.memberNames(currentConfiguration)) {
                BlobStore existingMember;
                if (memberNames.contains(existingMemberName) || !(existingMember = this.blobStoreManager.get(existingMemberName)).isWritable() && existingMember.getMetrics().getBlobCount() <= 0L) continue;
                throw new ValidationException(String.format("Blob Store '%s' cannot be removed from Blob Store Group '%s', use 'Admin - Remove a member from a blob store group' task instead", existingMemberName, name));
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return Optional.of(this.blobStoreGroupService).map(Provider::get).map(BlobStoreGroupService::isEnabled).orElse(false);
    }

    @Override
    public boolean configHasDependencyOn(BlobStoreConfiguration config, String blobStoreName) {
        return BlobStoreGroupConfigurationHelper.memberNames(config).contains(blobStoreName);
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="Group")
        public String name();

        @MessageBundle.DefaultMessage(value="Members")
        public String membersLabel();

        @MessageBundle.DefaultMessage(value="Fill Policy")
        public String fillPolicyLabel();
    }
}

