/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.group.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.sonatype.nexus.blobstore.api.BlobStoreMetrics;
import org.sonatype.nexus.common.math.Math2;

public class BlobStoreGroupMetrics
implements BlobStoreMetrics {
    private final long blobCount;
    private final long totalSize;
    private final Map<String, Long> availableSpaceByFileStore;
    private final boolean unlimited;

    public BlobStoreGroupMetrics(Iterable<BlobStoreMetrics> membersMetrics) {
        long aggregatedBlobCount = 0L;
        long aggregatedTotalSize = 0L;
        HashMap aggregatedAvailableSpaceByFileStore = new HashMap();
        boolean aggregatedUnlimited = false;
        for (BlobStoreMetrics memberMetrics : membersMetrics) {
            aggregatedBlobCount = Math2.addClamped((long)aggregatedBlobCount, (long)memberMetrics.getBlobCount());
            aggregatedTotalSize = Math2.addClamped((long)aggregatedTotalSize, (long)memberMetrics.getTotalSize());
            aggregatedAvailableSpaceByFileStore.putAll(memberMetrics.getAvailableSpaceByFileStore());
            boolean bl = aggregatedUnlimited = aggregatedUnlimited || memberMetrics.isUnlimited();
        }
        this.blobCount = aggregatedBlobCount;
        this.totalSize = aggregatedTotalSize;
        this.availableSpaceByFileStore = Collections.unmodifiableMap(aggregatedAvailableSpaceByFileStore);
        this.unlimited = aggregatedUnlimited;
    }

    public long getBlobCount() {
        return this.blobCount;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public long getAvailableSpace() {
        return this.availableSpaceByFileStore.values().stream().reduce(Math2::addClamped).orElse(0L);
    }

    public boolean isUnlimited() {
        return this.unlimited;
    }

    public Map<String, Long> getAvailableSpaceByFileStore() {
        return this.availableSpaceByFileStore;
    }
}

