/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.quota;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;
import org.sonatype.nexus.blobstore.quota.BlobStoreQuota;
import org.sonatype.nexus.blobstore.quota.BlobStoreQuotaResult;
import org.sonatype.nexus.blobstore.quota.BlobStoreQuotaService;

public abstract class BlobStoreQuotaSupport
extends ComponentSupport
implements BlobStoreQuota {
    public static final String ROOT_KEY = "blobStoreQuotaConfig";
    public static final String TYPE_KEY = "quotaType";
    public static final String LIMIT_KEY = "quotaLimitBytes";

    public static String convertBytesToSI(long bytes) {
        SIPrefix prefix;
        if (bytes == 0L) {
            prefix = SIPrefix.BYTE;
        } else {
            double exponent = Math.floor(Math.log10(Math.abs(bytes)));
            prefix = SIPrefix.values()[(int)exponent / 3];
        }
        return String.format("%.2f %s", (double)bytes / prefix.value, prefix.name);
    }

    public static Runnable createQuotaCheckJob(BlobStore blobStore, BlobStoreQuotaService quotaService, Logger logger) {
        return () -> BlobStoreQuotaSupport.quotaCheckJob(blobStore, quotaService, logger);
    }

    @VisibleForTesting
    static void quotaCheckJob(BlobStore blobStore, BlobStoreQuotaService quotaService, Logger logger) {
        try {
            BlobStoreQuotaResult result = quotaService.checkQuota(blobStore);
            if (result != null && result.isViolation()) {
                logger.warn(result.getMessage());
            }
        }
        catch (Exception e) {
            logger.error("Quota check exception for {}", (Object)blobStore.getBlobStoreConfiguration().getName(), (Object)e);
        }
    }

    public static long getLimit(BlobStoreConfiguration config) {
        Number limitObj = (Number)config.attributes(ROOT_KEY).get(LIMIT_KEY, Number.class);
        Preconditions.checkArgument((limitObj != null ? 1 : 0) != 0, (Object)"Limit not found in configuration");
        return limitObj.longValue();
    }

    public String toString() {
        return this.getDisplayName();
    }

    private static enum SIPrefix {
        BYTE("B", Math.pow(10.0, 0.0)),
        KILO("KB", Math.pow(10.0, 3.0)),
        MEGA("MB", Math.pow(10.0, 6.0)),
        GIGA("GB", Math.pow(10.0, 9.0)),
        TERA("TB", Math.pow(10.0, 12.0)),
        PETA("PB", Math.pow(10.0, 15.0)),
        EXA("EB", Math.pow(10.0, 18.0));

        final String name;
        final double value;

        private SIPrefix(String name, double value) {
            this.name = name;
            this.value = value;
        }
    }
}

