/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.quota.internal;

import com.google.common.base.Preconditions;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.validation.ValidationException;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;
import org.sonatype.nexus.blobstore.quota.BlobStoreQuotaResult;
import org.sonatype.nexus.blobstore.quota.BlobStoreQuotaSupport;

@Named(value="spaceRemainingQuota")
@Singleton
public class SpaceRemainingQuota
extends BlobStoreQuotaSupport {
    public static final String ID = "spaceRemainingQuota";
    private static final String DISPLAY_NAME = "Space Remaining";

    @Override
    public void validateConfig(BlobStoreConfiguration config) {
        if (SpaceRemainingQuota.getLimit(config) <= 0L) {
            throw new ValidationException("Space Remaining quotas must have a Quota Limit greater than 0");
        }
    }

    @Override
    public BlobStoreQuotaResult check(BlobStore blobStore) {
        Preconditions.checkNotNull((Object)blobStore);
        long availableSpace = blobStore.getMetrics().getAvailableSpace();
        boolean isUnlimited = blobStore.getMetrics().isUnlimited();
        long limit = SpaceRemainingQuota.getLimit(blobStore.getBlobStoreConfiguration());
        String name = blobStore.getBlobStoreConfiguration().getName();
        String msg = String.format("Blob store %s is limited to having %s available space, and has %s space remaining", name, SpaceRemainingQuota.convertBytesToSI(limit), SpaceRemainingQuota.convertBytesToSI(availableSpace));
        return new BlobStoreQuotaResult(!isUnlimited && availableSpace < limit, name, msg);
    }

    @Override
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @Override
    public String getId() {
        return ID;
    }
}

