/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.quota.internal;

import com.google.common.base.Preconditions;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.validation.ValidationException;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;
import org.sonatype.nexus.blobstore.quota.BlobStoreQuotaResult;
import org.sonatype.nexus.blobstore.quota.BlobStoreQuotaSupport;

@Named(value="spaceUsedQuota")
@Singleton
public class SpaceUsedQuota
extends BlobStoreQuotaSupport {
    public static final String ID = "spaceUsedQuota";
    private static final String DISPLAY_NAME = "Space Used";

    @Override
    public void validateConfig(BlobStoreConfiguration config) {
        if (SpaceUsedQuota.getLimit(config) <= 0L) {
            throw new ValidationException("Space Used quotas must have a Quota Limit greater than 0");
        }
    }

    @Override
    public BlobStoreQuotaResult check(BlobStore blobStore) {
        Preconditions.checkNotNull((Object)blobStore);
        long usedSpace = blobStore.getMetrics().getTotalSize();
        long limit = SpaceUsedQuota.getLimit(blobStore.getBlobStoreConfiguration());
        String name = blobStore.getBlobStoreConfiguration().getName();
        String msg = String.format("Blob store %s is using %s space and has a limit of %s", name, SpaceUsedQuota.convertBytesToSI(usedSpace), SpaceUsedQuota.convertBytesToSI(limit));
        return new BlobStoreQuotaResult(usedSpace > limit, name, msg);
    }

    @Override
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @Override
    public String getId() {
        return ID;
    }
}

