/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.rest;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.blobstore.quota.BlobStoreQuotaResult;
import org.sonatype.nexus.blobstore.quota.BlobStoreQuotaService;
import org.sonatype.nexus.blobstore.rest.BlobStoreQuotaResultXO;
import org.sonatype.nexus.blobstore.rest.BlobStoreResourceDoc;
import org.sonatype.nexus.rest.Resource;

@Named
@Singleton
@Path(value="/v1/blobstores")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class BlobStoreResource
extends ComponentSupport
implements Resource,
BlobStoreResourceDoc {
    public static final String RESOURCE_URI = "/v1/blobstores";
    private final BlobStoreManager blobStoreManager;
    private final BlobStoreQuotaService quotaService;

    @Inject
    public BlobStoreResource(BlobStoreManager blobStoreManager, BlobStoreQuotaService quotaService) {
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
        this.quotaService = (BlobStoreQuotaService)Preconditions.checkNotNull((Object)quotaService);
    }

    @Override
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:blobstores:read"})
    @GET
    @Path(value="/{id}/quota-status")
    public BlobStoreQuotaResultXO quotaStatus(@PathParam(value="id") String id) {
        BlobStore blobStore = this.blobStoreManager.get(id);
        if (blobStore == null) {
            throw new WebApplicationException(String.format("No blob store found for id '%s' ", id), Response.Status.NOT_FOUND);
        }
        BlobStoreQuotaResult result = this.quotaService.checkQuota(blobStore);
        return result != null ? BlobStoreQuotaResultXO.asQuotaXO(result) : BlobStoreQuotaResultXO.asNoQuotaXO(id);
    }
}

