/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.extdirect.internal;

import com.google.common.base.Preconditions;
import com.google.inject.Key;
import com.softwarementors.extjs.djn.api.RegisteredMethod;
import com.softwarementors.extjs.djn.servlet.ssm.SsmDispatcher;
import java.lang.reflect.InvocationTargetException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.sisu.BeanEntry;
import org.eclipse.sisu.inject.BeanLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.extdirect.internal.ExtDirectExceptionHandler;
import org.sonatype.nexus.extdirect.model.Response;
import org.sonatype.nexus.extdirect.model.Responses;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SERVICES)
@Singleton
public class ExtDirectDispatcher
extends SsmDispatcher {
    private static final Logger log = LoggerFactory.getLogger(ExtDirectDispatcher.class);
    private final BeanLocator beanLocator;
    private final ExtDirectExceptionHandler exceptionHandler;

    @Inject
    public ExtDirectDispatcher(BeanLocator beanLocator, ExtDirectExceptionHandler exceptionHandler) {
        this.beanLocator = (BeanLocator)Preconditions.checkNotNull((Object)beanLocator);
        this.exceptionHandler = (ExtDirectExceptionHandler)Preconditions.checkNotNull((Object)exceptionHandler);
    }

    protected Object createInvokeInstanceForMethodWithDefaultConstructor(RegisteredMethod method) {
        log.debug("Creating instance of action class '{}' mapped to '{}", (Object)method.getActionClass().getName(), (Object)method.getActionName());
        Iterable actionInstance = this.beanLocator.locate(Key.get((Class)method.getActionClass()));
        return ((BeanEntry)actionInstance.iterator().next()).getValue();
    }

    protected Object invokeMethod(RegisteredMethod method, Object actionInstance, Object[] parameters) {
        log.debug("Invoking action method: {}, java-method: {}", (Object)method.getFullName(), (Object)method.getFullJavaMethodName());
        Response response = null;
        MDC.put((String)((Object)((Object)this)).getClass().getName(), (String)method.getFullName());
        try {
            try {
                response = this.asResponse(super.invokeMethod(method, actionInstance, parameters));
            }
            catch (InvocationTargetException e) {
                response = this.asResponse(this.exceptionHandler.handleException(method, e.getTargetException()));
                MDC.remove((String)((Object)((Object)this)).getClass().getName());
            }
            catch (Exception e) {
                response = this.asResponse(this.exceptionHandler.handleException(method, e));
                MDC.remove((String)((Object)((Object)this)).getClass().getName());
            }
        }
        finally {
            MDC.remove((String)((Object)((Object)this)).getClass().getName());
        }
        return response;
    }

    private Response asResponse(Object result) {
        Response<Object> response = result == null ? Responses.success() : (result instanceof Response ? (Response<Object>)result : Responses.success(result));
        return response;
    }
}

