/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.extdirect.internal;

import com.orientechnologies.common.exception.OException;
import com.softwarementors.extjs.djn.api.RegisteredMethod;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.validation.ConstraintViolationException;
import org.apache.commons.collections.ListUtils;
import org.apache.shiro.authz.UnauthenticatedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.extdirect.model.Response;
import org.sonatype.nexus.extdirect.model.Responses;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SERVICES)
@Singleton
public class ExtDirectExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(ExtDirectExceptionHandler.class);
    private static final List<Class<Throwable>> SUPPRESSED_EXCEPTIONS = ListUtils.unmodifiableList(Arrays.asList(UnauthenticatedException.class));

    public Response handleException(RegisteredMethod method, Throwable e) {
        ConstraintViolationException cause;
        Set violations;
        log.debug("Failed to invoke action method: {}, java-method: {}, exception message: {}", new Object[]{method.getFullName(), method.getFullJavaMethodName(), e.getMessage(), this.isSuppressedException(e) ? null : e});
        if (e instanceof ConstraintViolationException && (violations = (cause = (ConstraintViolationException)e).getConstraintViolations()) != null && !violations.isEmpty()) {
            return Responses.invalid(cause);
        }
        if (!this.isSuppressedException(e)) {
            log.error("Failed to invoke action method: {}, java-method: {}", new Object[]{method.getFullName(), method.getFullJavaMethodName(), e});
        }
        if (e instanceof OException) {
            return Responses.error(new Exception("A database error occurred"));
        }
        return Responses.error(e);
    }

    private boolean isSuppressedException(Throwable e) {
        return SUPPRESSED_EXCEPTIONS.stream().anyMatch(ex -> ex.isInstance(e));
    }
}

