/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.extdirect.internal;

import com.google.common.collect.Maps;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.servlet.ServletModule;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.extdirect.internal.ExtDirectGsonBuilderConfigurator;
import org.sonatype.nexus.extdirect.internal.ExtDirectJsonRequestProcessorThread;
import org.sonatype.nexus.extdirect.internal.ExtDirectServlet;
import org.sonatype.nexus.security.FilterChainModule;
import org.sonatype.nexus.security.SecurityFilter;

@Named
public class ExtDirectModule
extends AbstractModule {
    private static final Logger log = LoggerFactory.getLogger(ExtDirectModule.class);
    private static final String MOUNT_POINT = "/service/extdirect";

    protected void configure() {
        this.install((Module)new ServletModule(){

            protected void configureServlets() {
                HashMap config = Maps.newHashMap();
                config.put("providersUrl", ExtDirectModule.MOUNT_POINT.substring(1));
                config.put("minify", Boolean.FALSE.toString());
                config.put("debug", Boolean.toString(log.isDebugEnabled()));
                config.put("jsonRequestProcessorThreadClass", ExtDirectJsonRequestProcessorThread.class.getName());
                config.put("gsonBuilderConfiguratorClass", ExtDirectGsonBuilderConfigurator.class.getName());
                this.serve("/service/extdirect*", new String[0]).with(ExtDirectServlet.class, (Map)config);
                this.filter("/service/extdirect*", new String[0]).through(SecurityFilter.class);
            }
        });
        this.install((Module)new FilterChainModule(){

            protected void configure() {
                this.addFilterChain("/service/extdirect/**", new String[]{"nx-authc", "nx-anonymous", "nx-anticsrf-authc"});
            }
        });
    }
}

