/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.extdirect.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.webresources.FileWebResource;
import org.sonatype.nexus.webresources.WebResource;
import org.sonatype.nexus.webresources.WebResourceBundle;

@Named
@Singleton
public class ExtDirectWebResources
implements WebResourceBundle {
    private final ApplicationDirectories directories;

    @Inject
    public ExtDirectWebResources(ApplicationDirectories directories) {
        this.directories = (ApplicationDirectories)Preconditions.checkNotNull((Object)directories);
    }

    private WebResource create(String fileName, String path) {
        File file = new File(this.directories.getTemporaryDirectory(), fileName);
        return new FileWebResource(file, path, "application/x-javascript", true);
    }

    public List<WebResource> getResources() {
        return ImmutableList.of((Object)this.create("nexus-extdirect/api.js", "/static/rapture/extdirect-prod.js"), (Object)this.create("nexus-extdirect/api-debug.js", "/static/rapture/extdirect-debug.js"));
    }
}

