/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.extdirect.model;

import com.google.common.base.Preconditions;
import java.util.List;

public class StoreLoadParameters {
    private Integer page;
    private Integer start;
    private Integer limit;
    private List<Sort> sort;
    private List<Filter> filter;

    public Integer getPage() {
        return this.page;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public Integer getStart() {
        return this.start;
    }

    public void setStart(Integer start) {
        this.start = start;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public List<Filter> getFilters() {
        return this.filter;
    }

    public void setFilter(List<Filter> filter) {
        this.filter = filter;
    }

    public String getFilter(String property) {
        Preconditions.checkNotNull((Object)property, (Object)"property");
        if (this.filter != null) {
            for (Filter item : this.filter) {
                if (!property.equals(item.getProperty())) continue;
                return item.getValue();
            }
        }
        return null;
    }

    public List<Sort> getSort() {
        return this.sort;
    }

    public void setSort(List<Sort> sort) {
        this.sort = sort;
    }

    public String toString() {
        return "StoreLoadParameters{page=" + this.page + ", start=" + this.start + ", limit=" + this.limit + ", sort=" + this.sort + ", filter=" + this.filter + '}';
    }

    public static class Filter {
        private String property;
        private String value;

        public String getProperty() {
            return this.property;
        }

        public void setProperty(String property) {
            this.property = property;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String toString() {
            return "Filter{property='" + this.property + '\'' + ", value='" + this.value + '\'' + '}';
        }
    }

    public static class Sort {
        private String property;
        private String direction;

        public String getProperty() {
            return this.property;
        }

        public void setProperty(String property) {
            this.property = property;
        }

        public String getDirection() {
            return this.direction;
        }

        public void setDirection(String value) {
            this.direction = value;
        }

        public String toString() {
            return "Sort{property='" + this.property + '\'' + ", direction='" + this.direction + '\'' + '}';
        }
    }
}

