/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.extdirect.model;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.ElementKind;
import javax.validation.Path;
import org.sonatype.nexus.extdirect.model.Response;

public class ValidationResponse
extends Response<Object> {
    private List<String> messages;
    private Map<String, String> errors;

    public ValidationResponse(ConstraintViolationException cause) {
        super(false, new ArrayList());
        Preconditions.checkNotNull((Object)cause);
        Set violations = cause.getConstraintViolations();
        if (violations != null && !violations.isEmpty()) {
            for (ConstraintViolation violation : violations) {
                ArrayList<String> entries = new ArrayList<String>();
                Iterator it = violation.getPropertyPath().iterator();
                while (it.hasNext()) {
                    Path.Node node = (Path.Node)it.next();
                    if (ElementKind.PROPERTY != node.getKind() && (ElementKind.PARAMETER != node.getKind() || it.hasNext())) continue;
                    if (node.getKey() != null) {
                        entries.add(node.getKey().toString());
                    }
                    entries.add(node.getName());
                }
                if (entries.isEmpty()) {
                    if (this.messages == null) {
                        this.messages = new ArrayList<String>();
                    }
                    this.messages.add(violation.getMessage());
                    continue;
                }
                if (this.errors == null) {
                    this.errors = new HashMap<String, String>();
                }
                this.errors.put(Joiner.on((char)'.').join(entries), violation.getMessage());
            }
        } else if (cause.getMessage() != null) {
            this.messages = new ArrayList<String>();
            this.messages.add(cause.getMessage());
        }
    }
}

