/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.pypi;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.pypi.internal.PyPiDataUtils;
import org.sonatype.nexus.repository.pypi.internal.PyPiHostedFacet;
import org.sonatype.nexus.repository.rest.UploadDefinitionExtension;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.VariableResolverAdapter;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.TempBlob;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.upload.AssetUpload;
import org.sonatype.nexus.repository.upload.ComponentUpload;
import org.sonatype.nexus.repository.upload.UploadDefinition;
import org.sonatype.nexus.repository.upload.UploadHandlerSupport;
import org.sonatype.nexus.repository.upload.UploadResponse;
import org.sonatype.nexus.repository.view.PartPayload;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.TempBlobPartPayload;
import org.sonatype.nexus.rest.ValidationErrorsException;

@Named(value="pypi")
@Singleton
public class PyPiUploadHandler
extends UploadHandlerSupport {
    private UploadDefinition definition;
    private final ContentPermissionChecker contentPermissionChecker;
    private final VariableResolverAdapter variableResolverAdapter;

    @Inject
    public PyPiUploadHandler(ContentPermissionChecker contentPermissionChecker, @Named(value="simple") VariableResolverAdapter variableResolverAdapter, Set<UploadDefinitionExtension> uploadDefinitionExtensions) {
        super(uploadDefinitionExtensions);
        this.contentPermissionChecker = contentPermissionChecker;
        this.variableResolverAdapter = variableResolverAdapter;
    }

    public UploadResponse handle(Repository repository, ComponentUpload upload) throws IOException {
        PyPiHostedFacet facet = (PyPiHostedFacet)repository.facet(PyPiHostedFacet.class);
        StorageFacet storageFacet = (StorageFacet)repository.facet(StorageFacet.class);
        PartPayload payload = ((AssetUpload)upload.getAssetUploads().get(0)).getPayload();
        Throwable throwable = null;
        Object var7_8 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob((Payload)payload, PyPiDataUtils.HASH_ALGORITHMS);){
            Map<String, String> metadata = facet.extractMetadata(tempBlob);
            if (metadata.isEmpty()) {
                throw new ValidationErrorsException("Unable to extract PyPI metadata from provided archive.");
            }
            String name = metadata.get("name");
            String version = metadata.get("version");
            if (Strings2.isBlank((String)name)) {
                throw new ValidationErrorsException("Metadata is missing the name attribute");
            }
            if (Strings2.isBlank((String)version)) {
                throw new ValidationErrorsException("Metadata is missing the version attribute");
            }
            String filename = StringUtils.isNotBlank((CharSequence)payload.getName()) ? payload.getName() : String.valueOf(name) + '-' + version + '.' + metadata.get("archive_type");
            String path = facet.createPackagePath(name, version, filename);
            this.ensurePermitted(repository.getName(), "pypi", path, this.coordinatesFromMetadata(metadata));
            return (UploadResponse)TransactionalStoreBlob.operation.withDb(storageFacet.txSupplier()).throwing(IOException.class).call(() -> new UploadResponse(facet.upload(filename, metadata, new TempBlobPartPayload(payload, tempBlob))));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Map<String, String> coordinatesFromMetadata(Map<String, String> packageMetadata) {
        return ImmutableMap.of((Object)"name", (Object)packageMetadata.get("name"), (Object)"version", (Object)packageMetadata.get("version"));
    }

    public UploadDefinition getDefinition() {
        if (this.definition == null) {
            this.definition = this.getDefinition("pypi", false);
        }
        return this.definition;
    }

    public VariableResolverAdapter getVariableResolverAdapter() {
        return this.variableResolverAdapter;
    }

    public ContentPermissionChecker contentPermissionChecker() {
        return this.contentPermissionChecker;
    }
}

