/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.pypi.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.io.CharStreams;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.pypi.internal.PyPiDataUtils;
import org.sonatype.nexus.repository.pypi.internal.PyPiHostedFacet;
import org.sonatype.nexus.repository.pypi.internal.PyPiPathUtils;
import org.sonatype.nexus.repository.pypi.internal.PyPiSearchResult;
import org.sonatype.nexus.repository.pypi.internal.PyPiSearchUtils;
import org.sonatype.nexus.repository.search.SearchService;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.PartPayload;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;
import org.sonatype.nexus.repository.view.payloads.StringPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlobPartPayload;

@Named
@Singleton
public final class HostedHandlers
extends ComponentSupport {
    private final SearchService searchService;
    final Handler getRootIndex = context -> {
        Content content = ((PyPiHostedFacet)context.getRepository().facet(PyPiHostedFacet.class)).getRootIndex();
        if (content != null) {
            return HttpResponses.ok((Payload)content);
        }
        return HttpResponses.notFound();
    };
    final Handler getIndex = context -> {
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        Content content = ((PyPiHostedFacet)context.getRepository().facet(PyPiHostedFacet.class)).getIndex(PyPiPathUtils.name(state));
        if (content != null) {
            return HttpResponses.ok((Payload)content);
        }
        return HttpResponses.notFound();
    };
    final Handler getPackage = context -> {
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        Content content = ((PyPiHostedFacet)context.getRepository().facet(PyPiHostedFacet.class)).getPackage(PyPiPathUtils.packagesPath(PyPiPathUtils.path(state)));
        if (content != null) {
            return HttpResponses.ok((Payload)content);
        }
        return HttpResponses.notFound();
    };
    final Handler postContent = context -> {
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        Throwable throwable = null;
        Object var4_5 = null;
        try (TempBlobPartPayload upload = this.extractPayloads(context, attributes);){
            String action = (String)attributes.get(":action");
            if (!"file_upload".equals(action)) {
                throw new IllegalStateException("Unsupported :action, found: " + action);
            }
            ((PyPiHostedFacet)context.getRepository().facet(PyPiHostedFacet.class)).upload(upload.getName(), attributes, upload);
            return HttpResponses.ok();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    };

    @Inject
    public HostedHandlers(SearchService searchService) {
        this.searchService = (SearchService)Preconditions.checkNotNull((Object)searchService);
    }

    private TempBlobPartPayload extractPayloads(Context context, Map<String, String> attributes) throws IOException {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull(attributes);
        Repository repository = context.getRepository();
        Request request = context.getRequest();
        Iterable payloads = (Iterable)Preconditions.checkNotNull((Object)request.getMultiparts());
        TempBlobPartPayload upload = null;
        for (PartPayload payload : payloads) {
            if (payload.isFormField()) {
                this.addAttribute(attributes, payload);
                continue;
            }
            if (!"content".equals(payload.getFieldName())) continue;
            if (upload != null) {
                throw new IllegalStateException();
            }
            StorageFacet storageFacet = (StorageFacet)repository.facet(StorageFacet.class);
            upload = new TempBlobPartPayload(payload, storageFacet.createTempBlob((Payload)payload, PyPiDataUtils.HASH_ALGORITHMS));
        }
        if (upload == null) {
            throw new IllegalStateException();
        }
        return upload;
    }

    private void addAttribute(Map<String, String> attributes, PartPayload payload) throws IOException {
        Preconditions.checkNotNull(attributes);
        Preconditions.checkNotNull((Object)payload);
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(payload.openInputStream(), StandardCharsets.UTF_8));){
            String fieldName = payload.getFieldName();
            String newValue = CharStreams.toString((Readable)reader);
            String oldValue = attributes.get(payload.getFieldName());
            if (oldValue != null && !oldValue.isEmpty()) {
                newValue = String.valueOf(oldValue) + "\n" + newValue;
            }
            attributes.put(fieldName, newValue);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public Handler search() {
        return context -> {
            Payload payload = (Payload)Preconditions.checkNotNull((Object)context.getRequest().getPayload());
            Throwable throwable = null;
            Object var4_5 = null;
            try (InputStream is = payload.openInputStream();){
                QueryBuilder query = PyPiSearchUtils.parseSearchRequest(context.getRepository().getName(), is);
                ArrayList<PyPiSearchResult> results = new ArrayList<PyPiSearchResult>();
                for (SearchHit hit : this.searchService.browseUnrestricted(query)) {
                    Map source = hit.getSource();
                    Map formatAttributes = source.getOrDefault("attributes", Collections.emptyMap());
                    Map pypiAttributes = formatAttributes.getOrDefault("pypi", Collections.emptyMap());
                    String name = Strings.nullToEmpty((String)((String)pypiAttributes.get("name")));
                    String version = Strings.nullToEmpty((String)((String)pypiAttributes.get("version")));
                    String summary = Strings.nullToEmpty((String)((String)pypiAttributes.get("summary")));
                    results.add(new PyPiSearchResult(name, version, summary));
                }
                String response = PyPiSearchUtils.buildSearchResponse(results);
                return HttpResponses.ok((Payload)new StringPayload(response, "application/xml"));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        };
    }
}

