/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.pypi.internal;

import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.template.TemplateHelper;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.group.GroupHandler;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.pypi.internal.AssetKind;
import org.sonatype.nexus.repository.pypi.internal.PyPiGroupFacet;
import org.sonatype.nexus.repository.pypi.internal.PyPiIndexUtils;
import org.sonatype.nexus.repository.pypi.internal.PyPiPathUtils;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;
import org.sonatype.nexus.repository.view.payloads.StringPayload;

@Named
@Singleton
class IndexGroupHandler
extends GroupHandler {
    private final TemplateHelper templateHelper;

    @Inject
    public IndexGroupHandler(TemplateHelper templateHelper) {
        this.templateHelper = (TemplateHelper)Preconditions.checkNotNull((Object)templateHelper);
    }

    protected Response doGet(@Nonnull Context context, @Nonnull GroupHandler.DispatchedRepositories dispatched) throws Exception {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)dispatched);
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().get(AssetKind.class));
        String name = AssetKind.ROOT_INDEX.equals((Object)assetKind) ? "simple/" : PyPiPathUtils.name((TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class));
        PyPiGroupFacet groupFacet = (PyPiGroupFacet)context.getRepository().facet(PyPiGroupFacet.class);
        Content content = groupFacet.getFromCache(name, assetKind);
        LinkedHashMap memberResponses = this.getAll(context, groupFacet.members(), dispatched);
        if (groupFacet.isStale(name, content, memberResponses)) {
            String html = this.mergeResponses(name, assetKind, memberResponses);
            Content newContent = new Content((Payload)new StringPayload(html, "text/html"));
            return HttpResponses.ok((Payload)groupFacet.saveToCache(name, newContent));
        }
        return HttpResponses.ok((Payload)content);
    }

    private String mergeResponses(String name, AssetKind assetKind, Map<Repository, Response> remoteResponses) throws Exception {
        TreeMap<String, String> results = new TreeMap<String, String>();
        for (Map.Entry<Repository, Response> entry : remoteResponses.entrySet()) {
            Response response = entry.getValue();
            if (response.getStatus().getCode() != 200 || response.getPayload() == null) continue;
            this.processResults(response, results);
        }
        if (AssetKind.INDEX.equals((Object)assetKind)) {
            return PyPiIndexUtils.buildIndexPage(this.templateHelper, name, results);
        }
        return PyPiIndexUtils.buildRootIndexPage(this.templateHelper, results);
    }

    private void processResults(Response response, Map<String, String> results) throws Exception {
        Preconditions.checkNotNull((Object)response);
        Preconditions.checkNotNull(results);
        Payload payload = (Payload)Preconditions.checkNotNull((Object)response.getPayload());
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStream in = payload.openInputStream();){
            Map<String, String> links = PyPiIndexUtils.extractLinksFromIndex(in);
            for (Map.Entry<String, String> link : links.entrySet()) {
                String file = link.getKey();
                String path = link.getValue();
                if (results.containsKey(file)) continue;
                results.put(file, path);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

