/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.pypi.internal;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.joda.time.DateTime;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.pypi.PyPiFacet;
import org.sonatype.nexus.repository.pypi.internal.AssetKind;
import org.sonatype.nexus.repository.pypi.internal.PyPiDataUtils;
import org.sonatype.nexus.repository.pypi.internal.PyPiFileUtils;
import org.sonatype.nexus.repository.pypi.internal.PyPiInfoUtils;
import org.sonatype.nexus.repository.pypi.internal.PyPiPathUtils;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.AssetEntityAdapter;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class PyPiFacetImpl
extends FacetSupport
implements PyPiFacet {
    private final AssetEntityAdapter assetEntityAdapter;

    @Inject
    public PyPiFacetImpl(AssetEntityAdapter assetEntityAdapter) {
        this.assetEntityAdapter = (AssetEntityAdapter)Preconditions.checkNotNull((Object)assetEntityAdapter);
    }

    @Override
    public boolean assetExists(String name) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        return this.assetEntityAdapter.exists(tx.getDb(), name, tx.findBucket(this.getRepository()));
    }

    @Override
    @Nullable
    public Asset put(String path, AssetBlob assetBlob) throws IOException {
        if (PyPiPathUtils.isPackagePath(path)) {
            return this.putPackage(path, assetBlob);
        }
        if (PyPiPathUtils.isRootIndexPath(path)) {
            this.log.info("Not repairing root index");
            return null;
        }
        if (PyPiPathUtils.isIndexPath(path)) {
            return this.putIndex(path, assetBlob);
        }
        this.log.warn("Path does not represent a PyPI package or index: {}", (Object)path);
        return null;
    }

    @Override
    public Asset putPackage(String path, AssetBlob assetBlob) throws IOException {
        Bucket bucket;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = PyPiDataUtils.findAsset(tx, bucket = tx.findBucket(this.getRepository()), path);
        if (asset == null) {
            Map<String, String> attributes;
            String filename = PyPiFileUtils.extractFilenameFromPath(path);
            Throwable throwable = null;
            Object var9_9 = null;
            try (InputStream is = assetBlob.getBlob().getInputStream();){
                attributes = PyPiInfoUtils.extractMetadata(is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            if (!attributes.containsKey("name")) {
                this.log.debug("No name found in metadata for {}, extracting from filename.", (Object)filename);
                attributes.put("name", PyPiPathUtils.normalizeName(PyPiFileUtils.extractNameFromFilename(filename)));
            }
            if (!attributes.containsKey("version")) {
                this.log.debug("No version found in metadata for {}, extracting from filename.", (Object)filename);
                attributes.put("version", PyPiFileUtils.extractVersionFromFilename(filename));
            }
            String name = attributes.get("name");
            String version = attributes.get("version");
            Component component = PyPiDataUtils.findComponent(tx, this.getRepository(), name, version);
            if (component == null) {
                component = tx.createComponent(bucket, this.getRepository().getFormat());
                component.name(name);
                component.version(version);
                component.formatAttributes().set("summary", (Object)attributes.get("summary"));
                tx.saveComponent(component);
            }
            asset = tx.createAsset(bucket, component);
            asset.name(path);
            PyPiDataUtils.copyAttributes(asset, attributes);
            this.saveAsset(tx, asset, assetBlob, AssetKind.PACKAGE);
        }
        return asset;
    }

    @Override
    public Asset putIndex(String path, AssetBlob assetBlob) {
        Bucket bucket;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = PyPiDataUtils.findAsset(tx, bucket = tx.findBucket(this.getRepository()), path);
        if (asset == null) {
            asset = tx.createAsset(bucket, this.getRepository().getFormat());
            asset.name(path);
            this.saveAsset(tx, asset, assetBlob, AssetKind.INDEX);
        }
        return asset;
    }

    private void saveAsset(StorageTx tx, Asset asset, AssetBlob assetBlob, AssetKind kind) {
        asset.formatAttributes().set("asset_kind", (Object)kind);
        tx.attachBlob(asset, assetBlob);
        DateTime blobCreationTime = assetBlob.getBlob().getMetrics().getCreationTime();
        asset.blobCreated(blobCreationTime);
        asset.blobUpdated(blobCreationTime);
        tx.saveAsset(asset);
    }
}

