/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.pypi.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.cache.CacheInfo;
import org.sonatype.nexus.repository.group.GroupFacetImpl;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.pypi.internal.AssetKind;
import org.sonatype.nexus.repository.pypi.internal.PyPiDataUtils;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.AssetCreatedEvent;
import org.sonatype.nexus.repository.storage.AssetDeletedEvent;
import org.sonatype.nexus.repository.storage.AssetEvent;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalDeleteBlob;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.payloads.BlobPayload;
import org.sonatype.nexus.transaction.UnitOfWork;
import org.sonatype.nexus.validation.ConstraintViolationFactory;

@Named
@Facet.Exposed
public class PyPiGroupFacet
extends GroupFacetImpl {
    @Inject
    public PyPiGroupFacet(RepositoryManager repositoryManager, ConstraintViolationFactory constraintViolationFactory, @Named(value="group") Type groupType) {
        super(repositoryManager, constraintViolationFactory, groupType);
    }

    @Subscribe
    @Guarded(by={"STARTED"})
    @AllowConcurrentEvents
    public void on(AssetCreatedEvent event) {
        this.maybeDeleteFromCache((AssetEvent)event);
    }

    @Subscribe
    @Guarded(by={"STARTED"})
    @AllowConcurrentEvents
    public void on(AssetDeletedEvent event) {
        this.maybeDeleteFromCache((AssetEvent)event);
    }

    private void maybeDeleteFromCache(AssetEvent event) {
        if (event.isLocal() && this.member(event.getRepositoryName()) && AssetKind.ROOT_INDEX.name().equals(event.getAsset().formatAttributes().get("asset_kind", String.class))) {
            this.deleteFromCache("simple/");
        }
    }

    private void deleteFromCache(String name) {
        UnitOfWork.begin((Supplier)((StorageFacet)this.getRepository().facet(StorageFacet.class)).txSupplier());
        try {
            this.doDeleteFromCache(name);
        }
        finally {
            UnitOfWork.end();
        }
    }

    @TransactionalDeleteBlob
    protected void doDeleteFromCache(String name) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = tx.findAssetWithProperty("name", (Object)name, tx.findBucket(this.getRepository()));
        if (asset != null) {
            this.log.info("Deleting cached content {} from {}", (Object)name, (Object)this.getRepository().getName());
            tx.deleteAsset(asset);
        }
    }

    @TransactionalTouchBlob
    public Content getFromCache(String name, AssetKind assetKind) {
        Preconditions.checkArgument((AssetKind.INDEX.equals((Object)assetKind) || AssetKind.ROOT_INDEX.equals((Object)assetKind) ? 1 : 0) != 0, (Object)"Only index files are cached");
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        Asset asset = PyPiDataUtils.findAsset(tx, bucket, name);
        if (asset == null) {
            return null;
        }
        return PyPiDataUtils.toContent(asset, tx.requireBlob(asset.blobRef()));
    }

    public boolean isStale(String name, Content content, Map<Repository, Response> responses) {
        DateTime cacheModified = this.extractLastModified(content);
        if (cacheModified == null || this.isStale(content)) {
            return true;
        }
        for (Map.Entry<Repository, Response> response : responses.entrySet()) {
            DateTime memberLastModified;
            Content responseContent;
            Response responseValue = response.getValue();
            if (responseValue.getStatus().getCode() != 200 || (responseContent = (Content)responseValue.getPayload()) == null || (memberLastModified = (DateTime)responseContent.getAttributes().get("lastModified", DateTime.class)) != null && !memberLastModified.isAfter((ReadableInstant)cacheModified)) continue;
            this.log.debug("Found stale content while fetching {} from repository {}", (Object)name, (Object)response.getKey().getName());
            return true;
        }
        return false;
    }

    @TransactionalStoreBlob
    public Payload saveToCache(String name, Content content) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = this.getAsset(tx, name);
        AttributesMap contentAttributes = Content.maintainLastModified((Asset)asset, null);
        contentAttributes.set(CacheInfo.class, (Object)this.cacheController.current());
        Content.applyToAsset((Asset)asset, (AttributesMap)contentAttributes);
        AssetBlob blob = this.updateAsset(tx, asset, content);
        Content response = new Content((Payload)new BlobPayload(blob.getBlob(), "text/html"));
        Content.extractFromAsset((Asset)asset, PyPiDataUtils.HASH_ALGORITHMS, (AttributesMap)response.getAttributes());
        return response;
    }

    private DateTime extractLastModified(Content content) {
        DateTime lastModified = content != null && content.getAttributes().contains("lastModified") ? (DateTime)content.getAttributes().get("lastModified", DateTime.class) : null;
        return lastModified;
    }

    @TransactionalStoreBlob
    protected AssetBlob updateAsset(StorageTx tx, Asset asset, Content content) throws IOException {
        AttributesMap contentAttributes = Content.maintainLastModified((Asset)asset, (AttributesMap)content.getAttributes());
        Content.applyToAsset((Asset)asset, (AttributesMap)contentAttributes);
        InputStream inputStream = content.openInputStream();
        AssetBlob blob = tx.setBlob(asset, asset.name(), () -> inputStream, PyPiDataUtils.HASH_ALGORITHMS, null, "text/html", true);
        tx.saveAsset(asset);
        return blob;
    }

    @TransactionalTouchBlob
    protected Asset getAsset(StorageTx tx, String name) {
        Bucket bucket = tx.findBucket(this.getRepository());
        Asset assets = PyPiDataUtils.findAsset(tx, bucket, name);
        if (assets == null) {
            assets = (Asset)tx.createAsset(bucket, this.getRepository().getFormat()).name(name);
            assets.formatAttributes().set("asset_kind", (Object)AssetKind.INDEX);
        }
        return assets;
    }
}

