/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.pypi.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Named;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.repository.pypi.internal.PyPiHostedFacet;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.DefaultComponentMaintenanceImpl;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalDeleteBlob;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class PyPiHostedComponentMaintenance
extends DefaultComponentMaintenanceImpl {
    @TransactionalDeleteBlob
    protected Set<String> deleteAssetTx(EntityId assetId, boolean deleteBlob) {
        Bucket bucket;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = tx.findAsset(assetId, bucket = tx.findBucket(this.getRepository()));
        if (asset == null) {
            return Collections.emptySet();
        }
        HashSet<String> deletedAssets = new HashSet<String>();
        deletedAssets.addAll(super.deleteAssetTx(assetId, deleteBlob));
        EntityId componentId = asset.componentId();
        if (componentId != null) {
            this.deleteRootIndex();
            this.deleteCachedIndex((String)asset.formatAttributes().get("name", String.class));
            Component component = tx.findComponentInBucket(componentId, bucket);
            if (component != null && !tx.browseAssets(component).iterator().hasNext()) {
                deletedAssets.addAll(this.deleteComponentTx(componentId, deleteBlob));
            }
        }
        return deletedAssets;
    }

    @TransactionalDeleteBlob
    protected Set<String> deleteComponentTx(EntityId componentId, boolean deleteBlobs) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Component component = tx.findComponentInBucket(componentId, tx.findBucket(this.getRepository()));
        if (component == null) {
            return Collections.emptySet();
        }
        this.deleteRootIndex();
        this.deleteCachedIndex(component.name());
        this.log.debug("Deleting component: {}", (Object)component.toStringExternal());
        return tx.deleteComponent(component, deleteBlobs);
    }

    private void deleteRootIndex() {
        PyPiHostedFacet facet = (PyPiHostedFacet)this.getRepository().facet(PyPiHostedFacet.class);
        facet.deleteRootIndex();
    }

    private void deleteCachedIndex(String assetName) {
        PyPiHostedFacet facet = (PyPiHostedFacet)this.getRepository().facet(PyPiHostedFacet.class);
        facet.deleteIndex(assetName);
    }
}

