/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.pypi.internal;

import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.template.TemplateHelper;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.IllegalOperationException;
import org.sonatype.nexus.repository.pypi.internal.AssetKind;
import org.sonatype.nexus.repository.pypi.internal.PyPiDataUtils;
import org.sonatype.nexus.repository.pypi.internal.PyPiHostedFacet;
import org.sonatype.nexus.repository.pypi.internal.PyPiIndexUtils;
import org.sonatype.nexus.repository.pypi.internal.PyPiInfoUtils;
import org.sonatype.nexus.repository.pypi.internal.PyPiPathUtils;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.storage.TempBlob;
import org.sonatype.nexus.repository.transaction.TransactionalDeleteBlob;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.transaction.TransactionalStoreMetadata;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.StringPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlobPartPayload;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class PyPiHostedFacetImpl
extends FacetSupport
implements PyPiHostedFacet {
    private final TemplateHelper templateHelper;

    @Inject
    public PyPiHostedFacetImpl(TemplateHelper templateHelper) {
        this.templateHelper = (TemplateHelper)Preconditions.checkNotNull((Object)templateHelper);
    }

    @Override
    @TransactionalStoreBlob
    @Nullable
    public Content getRootIndex() {
        Bucket bucket;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = PyPiDataUtils.findAsset(tx, bucket = tx.findBucket(this.getRepository()), "simple/");
        if (asset == null) {
            try {
                return this.createAndSaveRootIndex(bucket);
            }
            catch (IOException e) {
                this.log.error("Unable to create root index for repository: {}", (Object)this.getRepository().getName(), (Object)e);
                return null;
            }
        }
        return PyPiDataUtils.toContent(asset, tx.requireBlob(asset.requireBlobRef()));
    }

    private Content createAndSaveRootIndex(Bucket bucket) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Map<String, String> links = this.findAllLinks();
        Asset asset = this.createRootIndexAsset(bucket);
        String rootIndexHtml = PyPiIndexUtils.buildRootIndexPage(this.templateHelper, links);
        return this.storeHtmlPage(tx, asset, rootIndexHtml);
    }

    @TransactionalStoreMetadata
    protected Asset createRootIndexAsset(Bucket bucket) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = tx.createAsset(bucket, this.getRepository().getFormat());
        asset.name("simple/");
        asset.formatAttributes().set("asset_kind", (Object)AssetKind.ROOT_INDEX.name());
        return asset;
    }

    @Transactional
    protected Map<String, String> findAllLinks() {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        TreeMap<String, String> links = new TreeMap<String, String>();
        Iterable components = tx.browseComponents(tx.findBucket(this.getRepository()));
        components.forEach(component -> {
            String string = links.put(component.name(), String.valueOf(component.name()) + "/");
        });
        return links;
    }

    @TransactionalStoreBlob
    protected Content storeHtmlPage(StorageTx tx, Asset asset, String indexPage) throws IOException {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var6_7 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob((Payload)new StringPayload(indexPage, "text/html"), PyPiDataUtils.HASH_ALGORITHMS);){
            return PyPiDataUtils.saveAsset(tx, asset, tempBlob, "text/html", null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @TransactionalStoreBlob
    public Content getIndex(String name) throws IOException {
        Preconditions.checkNotNull((Object)name);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        if (!PyPiDataUtils.findComponentExists(tx, this.getRepository(), name)) {
            return null;
        }
        String indexPath = PyPiPathUtils.indexPath(name);
        Bucket bucket = tx.findBucket(this.getRepository());
        Asset savedIndex = PyPiDataUtils.findAsset(tx, bucket, indexPath);
        if (savedIndex == null) {
            savedIndex = this.createIndexAsset(name, tx, indexPath, bucket);
        }
        return PyPiDataUtils.toContent(savedIndex, tx.requireBlob(savedIndex.requireBlobRef()));
    }

    private Asset createIndexAsset(String name, StorageTx tx, String indexPath, Bucket bucket) throws IOException {
        String html = this.buildIndex(name, tx);
        Asset savedIndex = tx.createAsset(bucket, this.getRepository().getFormat());
        savedIndex.name(indexPath);
        savedIndex.formatAttributes().set("asset_kind", (Object)AssetKind.INDEX.name());
        StorageFacet storageFacet = (StorageFacet)this.getRepository().facet(StorageFacet.class);
        TempBlob tempBlob = storageFacet.createTempBlob((InputStream)new ByteArrayInputStream(html.getBytes(StandardCharsets.UTF_8)), PyPiDataUtils.HASH_ALGORITHMS);
        PyPiDataUtils.saveAsset(tx, savedIndex, tempBlob, "text/html", new AttributesMap());
        return savedIndex;
    }

    private String buildIndex(String name, StorageTx tx) {
        LinkedHashMap<String, String> links = new LinkedHashMap<String, String>();
        for (Asset asset : PyPiDataUtils.findAssetsByComponentName(tx, this.getRepository(), name)) {
            String path = asset.name();
            String file = path.substring(path.lastIndexOf(47) + 1);
            String link = String.format("../../%s#md5=%s", path, asset.getChecksum(HashAlgorithm.MD5));
            links.put(file, link);
        }
        return PyPiIndexUtils.buildIndexPage(this.templateHelper, name, links);
    }

    @Override
    @TransactionalTouchBlob
    public Content getPackage(String packagePath) {
        Preconditions.checkNotNull((Object)packagePath);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = PyPiDataUtils.findAsset(tx, tx.findBucket(this.getRepository()), packagePath);
        if (asset == null) {
            return null;
        }
        Content content = PyPiDataUtils.toContent(asset, tx.requireBlob(asset.requireBlobRef()));
        this.mayAddEtag(content.getAttributes(), asset.getChecksum(HashAlgorithm.SHA1));
        return content;
    }

    private void mayAddEtag(AttributesMap attributesMap, HashCode hashCode) {
        if (attributesMap.contains("etag")) {
            return;
        }
        if (hashCode != null) {
            attributesMap.set("etag", (Object)("{SHA1{" + hashCode + "}}"));
        }
    }

    @Override
    @TransactionalStoreBlob
    public Asset upload(String filename, Map<String, String> attributes, TempBlobPartPayload payload) throws IOException {
        HashCode hashCode;
        String hashValue;
        String expectedDigest;
        Preconditions.checkNotNull((Object)filename);
        TempBlob tempBlob = payload.getTempBlob();
        String name = (String)Preconditions.checkNotNull((Object)attributes.get("name"));
        String version = (String)Preconditions.checkNotNull((Object)attributes.get("version"));
        String normalizedName = PyPiPathUtils.normalizeName(name);
        if (attributes.containsKey("md5_digest") && !(expectedDigest = attributes.get("md5_digest")).equalsIgnoreCase(hashValue = (hashCode = (HashCode)tempBlob.getHashes().get(HashAlgorithm.MD5)).toString())) {
            throw new IllegalOperationException("Digests do not match, found: " + hashValue + ", expected: " + expectedDigest);
        }
        this.deleteIndex(name);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        String packagePath = this.createPackagePath(name, version, filename);
        Component component = PyPiDataUtils.findComponent(tx, this.getRepository(), normalizedName, version);
        if (component == null) {
            component = ((Component)tx.createComponent(bucket, this.getRepository().getFormat()).name(normalizedName)).version(version);
            this.setComponentName(component.formatAttributes(), name);
            component.formatAttributes().set("version", (Object)version);
            this.deleteRootIndex();
        }
        component.formatAttributes().set("summary", (Object)attributes.get("summary"));
        tx.saveComponent(component);
        Asset asset = PyPiDataUtils.findAsset(tx, bucket, packagePath);
        if (asset == null) {
            asset = tx.createAsset(bucket, component);
            asset.name(packagePath);
            asset.formatAttributes().set("asset_kind", (Object)AssetKind.PACKAGE.name());
        }
        PyPiDataUtils.copyAttributes(asset, attributes);
        PyPiDataUtils.saveAsset(tx, asset, tempBlob, (Payload)payload);
        return asset;
    }

    @Override
    @TransactionalDeleteBlob
    public void deleteIndex(String packageName) {
        String indexPath;
        Bucket bucket;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset cachedIndex = PyPiDataUtils.findAsset(tx, bucket = tx.findBucket(this.getRepository()), indexPath = PyPiPathUtils.indexPath(packageName));
        if (cachedIndex != null) {
            tx.deleteAsset(cachedIndex);
        }
    }

    @Override
    @TransactionalDeleteBlob
    public void deleteRootIndex() {
        Bucket bucket;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset rootIndex = PyPiDataUtils.findAsset(tx, bucket = tx.findBucket(this.getRepository()), "simple/");
        if (rootIndex != null) {
            tx.deleteAsset(rootIndex);
        }
    }

    private void setComponentName(NestedAttributesMap attributes, String name) {
        attributes.set("name", (Object)name);
        attributes.set("name_dash", (Object)PyPiPathUtils.normalizeName(name, "-"));
        attributes.set("name_dot", (Object)PyPiPathUtils.normalizeName(name, "."));
        attributes.set("name_underscore", (Object)PyPiPathUtils.normalizeName(name, "_"));
    }

    @Override
    public String createPackagePath(String name, String version, String filename) {
        String normalizedName = PyPiPathUtils.normalizeName(name);
        return PyPiPathUtils.packagesPath(normalizedName, version, filename);
    }

    @Override
    public Map<String, String> extractMetadata(TempBlob tempBlob) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream in = tempBlob.get();){
            return PyPiInfoUtils.extractMetadata(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

