/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.pypi.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.CharStreams;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.common.template.TemplateHelper;
import org.sonatype.nexus.common.template.TemplateParameters;

public final class PyPiIndexUtils {
    private static final Logger log = LoggerFactory.getLogger(PyPiIndexUtils.class);

    static Map<String, String> extractLinksFromIndex(InputStream in) throws IOException {
        Preconditions.checkNotNull((Object)in);
        LinkedHashMap<String, String> results = new LinkedHashMap<String, String>();
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
            String html = CharStreams.toString((Readable)reader);
            Document document = Jsoup.parse((String)html);
            Elements links = document.select("a[href]");
            for (Element link : links) {
                String file = link.text().trim();
                String path = link.attr("href");
                if (results.containsKey(file)) continue;
                results.put(file, path);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return results;
    }

    static String buildIndexPage(TemplateHelper helper, String name, Map<String, String> links) {
        Preconditions.checkNotNull((Object)helper);
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull(links);
        URL template = PyPiIndexUtils.class.getResource("pypi-index.vm");
        TemplateParameters params = helper.parameters();
        params.set("name", (Object)name);
        params.set("assets", links.entrySet().stream().map(link -> ImmutableMap.of((Object)"link", (Object)((String)link.getValue()), (Object)"file", (Object)((String)link.getKey()))).collect(Collectors.toList()));
        return helper.render(template, params);
    }

    static String buildRootIndexPage(TemplateHelper helper, Map<String, String> links) {
        Preconditions.checkNotNull((Object)helper);
        Preconditions.checkNotNull(links);
        URL template = PyPiIndexUtils.class.getResource("pypi-root-index.vm");
        TemplateParameters params = helper.parameters();
        params.set("assets", links.entrySet().stream().map(link -> {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("link", (String)link.getValue());
            data.put("name", (String)link.getKey());
            return data;
        }).collect(Collectors.toList()));
        return helper.render(template, params);
    }

    private static Map<String, String> makeLinksRelative(Map<String, String> oldLinks, Function<String, String> linkTranslator) {
        Preconditions.checkNotNull(oldLinks);
        LinkedHashMap<String, String> newLinks = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> oldLink : oldLinks.entrySet()) {
            String newLink = linkTranslator.apply(oldLink.getValue());
            if (newLink == null) continue;
            newLinks.put(oldLink.getKey(), newLink);
        }
        return newLinks;
    }

    static Map<String, String> makeIndexRelative(InputStream in) throws IOException {
        return PyPiIndexUtils.makePackageLinksRelative(PyPiIndexUtils.extractLinksFromIndex(in));
    }

    static Map<String, String> makePackageLinksRelative(Map<String, String> oldLinks) {
        return PyPiIndexUtils.makeLinksRelative(oldLinks, PyPiIndexUtils::maybeRewriteLink);
    }

    static Map<String, String> makeRootIndexRelative(InputStream in) throws IOException {
        return PyPiIndexUtils.makeRootIndexLinksRelative(PyPiIndexUtils.extractLinksFromIndex(in));
    }

    static Map<String, String> makeRootIndexLinksRelative(Map<String, String> oldLinks) {
        return PyPiIndexUtils.makeLinksRelative(oldLinks, PyPiIndexUtils::maybeRewriteRootLink);
    }

    @Nullable
    private static String maybeRewriteLink(String link) {
        if (link.startsWith("../../packages")) {
            log.trace("Found index page relative link, not rewriting: {}", (Object)link);
            return link;
        }
        int startIndex = link.indexOf("/packages");
        if (startIndex != -1) {
            log.trace("Rewriting link as relative (is this an absolute url for warehouse?): " + link);
            return "../.." + link.substring(startIndex);
        }
        log.trace("Found index page link without /packages reference, not rewriting: {}", (Object)link);
        return link;
    }

    private static String maybeRewriteRootLink(String link) {
        if (link.contains("/simple/")) {
            String[] split = link.split("/simple/");
            return split[1];
        }
        return link;
    }

    private PyPiIndexUtils() {
    }
}

