/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.pypi.internal;

import com.google.common.base.Preconditions;
import java.util.Locale;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;

public final class PyPiPathUtils {
    public static final String INDEX_PATH_PREFIX = "simple/";
    public static final String PACKAGE_PATH_PREFIX = "packages/";

    static boolean isSearchRequest(Request request) {
        return "POST".equals(request.getAction()) && request.getPath().endsWith("/pypi");
    }

    static TokenMatcher.State matcherState(Context context) {
        return (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
    }

    static String name(TokenMatcher.State state) {
        return PyPiPathUtils.match(state, "name");
    }

    static String path(TokenMatcher.State state) {
        return PyPiPathUtils.match(state, "path");
    }

    private static String match(TokenMatcher.State state, String name) {
        Preconditions.checkNotNull((Object)state);
        String result = (String)state.getTokens().get(name);
        Preconditions.checkNotNull((Object)result);
        return result;
    }

    static String indexPath(String name) {
        return INDEX_PATH_PREFIX + name + (name.endsWith("/") ? "" : "/");
    }

    static String packagesPath(String ... parts) {
        String pkg = String.join((CharSequence)"/", parts);
        return pkg.startsWith(PACKAGE_PATH_PREFIX) ? pkg : PACKAGE_PATH_PREFIX + pkg;
    }

    static String normalizeName(String name) {
        return name.replaceAll("[\\-\\_\\.]+", "-").toLowerCase(Locale.ENGLISH);
    }

    static String normalizeName(String name, String replace) {
        return name.replaceAll("[\\-\\_\\.]+", replace).toLowerCase(Locale.ENGLISH);
    }

    static boolean isRootIndexPath(String path) {
        return path.equals(INDEX_PATH_PREFIX);
    }

    static boolean isIndexPath(String path) {
        return path.startsWith(INDEX_PATH_PREFIX);
    }

    static boolean isPackagePath(String path) {
        return path.startsWith(PACKAGE_PATH_PREFIX);
    }

    private PyPiPathUtils() {
    }
}

