/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.pypi.internal;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.sonatype.nexus.common.template.TemplateHelper;
import org.sonatype.nexus.repository.cache.CacheController;
import org.sonatype.nexus.repository.cache.CacheInfo;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.proxy.ProxyFacetSupport;
import org.sonatype.nexus.repository.pypi.internal.AssetKind;
import org.sonatype.nexus.repository.pypi.internal.PyPiDataUtils;
import org.sonatype.nexus.repository.pypi.internal.PyPiFileUtils;
import org.sonatype.nexus.repository.pypi.internal.PyPiIndexUtils;
import org.sonatype.nexus.repository.pypi.internal.PyPiInfoUtils;
import org.sonatype.nexus.repository.pypi.internal.PyPiPathUtils;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.storage.TempBlob;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;
import org.sonatype.nexus.repository.transaction.TransactionalTouchMetadata;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class PyPiProxyFacetImpl
extends ProxyFacetSupport {
    private final TemplateHelper templateHelper;

    @Inject
    public PyPiProxyFacetImpl(TemplateHelper templateHelper) {
        this.templateHelper = (TemplateHelper)Preconditions.checkNotNull((Object)templateHelper);
    }

    protected void doValidate(Configuration configuration) throws Exception {
        super.doValidate(configuration);
    }

    @Nullable
    protected Content getCachedContent(Context context) throws IOException {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        if (assetKind.equals((Object)AssetKind.SEARCH)) {
            return null;
        }
        TokenMatcher.State state = PyPiPathUtils.matcherState(context);
        switch (assetKind) {
            case ROOT_INDEX: {
                return this.getAsset("simple/");
            }
            case INDEX: {
                return this.getAsset(PyPiPathUtils.indexPath(PyPiPathUtils.name(state)));
            }
            case PACKAGE: {
                return this.getAsset(PyPiPathUtils.packagesPath(PyPiPathUtils.path(state)));
            }
        }
        throw new IllegalStateException();
    }

    protected Content store(Context context, Content content) throws IOException {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        if (assetKind.equals((Object)AssetKind.SEARCH)) {
            return content;
        }
        TokenMatcher.State state = PyPiPathUtils.matcherState(context);
        switch (assetKind) {
            case ROOT_INDEX: {
                return this.putRootIndex(content);
            }
            case INDEX: {
                return this.putIndex(PyPiPathUtils.indexPath(PyPiPathUtils.name(state)), content);
            }
            case PACKAGE: {
                return this.putPackage(PyPiPathUtils.packagesPath(PyPiPathUtils.path(state)), content);
            }
        }
        throw new IllegalStateException();
    }

    protected void indicateVerified(Context context, Content content, CacheInfo cacheInfo) throws IOException {
        this.setCacheInfo(content, cacheInfo);
    }

    protected String getUrl(@Nonnull Context context) {
        String url = context.getRequest().getPath();
        return url.substring(1);
    }

    protected HttpRequestBase buildFetchHttpRequest(URI uri, Context context) {
        Request request = context.getRequest();
        if (PyPiPathUtils.isSearchRequest(request)) {
            Payload payload = (Payload)Preconditions.checkNotNull((Object)request.getPayload());
            try {
                ContentType contentType = ContentType.parse((String)payload.getContentType());
                HttpPost post = new HttpPost(uri);
                post.setEntity((HttpEntity)new InputStreamEntity(payload.openInputStream(), payload.getSize(), contentType));
                return post;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return super.buildFetchHttpRequest(uri, context);
    }

    @TransactionalTouchBlob
    protected Content getAsset(String name) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = PyPiDataUtils.findAsset(tx, tx.findBucket(this.getRepository()), name);
        if (asset == null) {
            return null;
        }
        return PyPiDataUtils.toContent(asset, tx.requireBlob(asset.requireBlobRef()));
    }

    private Content putPackage(String path, Content content) throws IOException {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob((Payload)content, PyPiDataUtils.HASH_ALGORITHMS);){
            return this.doPutPackage(path, tempBlob, (Payload)content);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @TransactionalStoreBlob
    protected Content doPutPackage(String path, TempBlob tempBlob, Payload payload) throws IOException {
        Asset asset;
        Map<String, String> attributes;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        String filename = PyPiFileUtils.extractFilenameFromPath(path);
        Throwable throwable = null;
        Object var9_9 = null;
        try (InputStream is = tempBlob.get();){
            attributes = PyPiInfoUtils.extractMetadata(is);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (!attributes.containsKey("name")) {
            this.log.debug("No name found in metadata for {}, extracting from filename.", (Object)filename);
            attributes.put("name", PyPiFileUtils.extractNameFromFilename(filename));
        }
        if (!attributes.containsKey("version")) {
            this.log.debug("No version found in metadata for {}, extracting from filename.", (Object)filename);
            attributes.put("version", PyPiFileUtils.extractVersionFromFilename(filename));
        }
        String name = attributes.get("name");
        String version = attributes.get("version");
        Component component = PyPiDataUtils.findComponent(tx, this.getRepository(), name, version);
        if (component == null) {
            component = ((Component)tx.createComponent(bucket, this.getRepository().getFormat()).name(name)).version(version);
        }
        if (component.isNew() || attributes.containsKey("summary")) {
            component.formatAttributes().set("summary", (Object)attributes.get("summary"));
            tx.saveComponent(component);
        }
        if ((asset = PyPiDataUtils.findAsset(tx, bucket, path)) == null) {
            asset = tx.createAsset(bucket, component);
            asset.name(path);
            asset.formatAttributes().set("asset_kind", (Object)AssetKind.PACKAGE.name());
        }
        PyPiDataUtils.copyAttributes(asset, attributes);
        return PyPiDataUtils.saveAsset(tx, asset, tempBlob, payload);
    }

    private Content putRootIndex(Content content) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream inputStream = content.openInputStream();){
            Map<String, String> links = PyPiIndexUtils.makeRootIndexRelative(inputStream);
            String indexPage = PyPiIndexUtils.buildRootIndexPage(this.templateHelper, links);
            return this.storeHtmlPage(content, indexPage, AssetKind.ROOT_INDEX, "simple/");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Content putIndex(String name, Content content) throws IOException {
        String html;
        Throwable throwable = null;
        Object var5_5 = null;
        try (InputStream inputStream = content.openInputStream();){
            Map<String, String> links = PyPiIndexUtils.makeIndexRelative(inputStream);
            html = PyPiIndexUtils.buildIndexPage(this.templateHelper, name.substring(name.indexOf(47) + 1, name.length() - 1), links);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return this.storeHtmlPage(content, html, AssetKind.INDEX, name);
    }

    /*
     * Exception decompiling
     */
    private Content storeHtmlPage(Content content, String indexPage, AssetKind rootIndex, String indexPathPrefix) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @TransactionalStoreBlob
    protected Content doPutIndex(String name, TempBlob tempBlob, Payload payload, Map<String, Object> attributes) throws IOException {
        Bucket bucket;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = PyPiDataUtils.findAsset(tx, bucket = tx.findBucket(this.getRepository()), name);
        if (asset == null) {
            asset = tx.createAsset(bucket, this.getRepository().getFormat());
            asset.name(name);
        }
        if (attributes != null) {
            for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                asset.formatAttributes().set(entry.getKey(), entry.getValue());
            }
        }
        return PyPiDataUtils.saveAsset(tx, asset, tempBlob, payload);
    }

    @TransactionalTouchMetadata
    protected void setCacheInfo(Content content, CacheInfo cacheInfo) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = Content.findAsset((StorageTx)tx, (Bucket)tx.findBucket(this.getRepository()), (Content)content);
        if (asset == null) {
            this.log.debug("Attempting to set cache info for non-existent pypi asset {}", content.getAttributes().require(Asset.class));
            return;
        }
        this.log.debug("Updating cacheInfo of {} to {}", (Object)asset, (Object)cacheInfo);
        CacheInfo.applyToAsset((Asset)asset, (CacheInfo)cacheInfo);
        tx.saveAsset(asset);
    }

    @Nonnull
    protected CacheController getCacheController(@Nonnull Context context) {
        AssetKind assetKind = (AssetKind)((Object)context.getAttributes().require(AssetKind.class));
        return this.cacheControllerHolder.require(assetKind.getCacheType());
    }
}

