/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.pypi.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.sonatype.nexus.repository.pypi.internal.PyPiSearchResult;
import org.sonatype.nexus.repository.pypi.internal.SearchResponseWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class PyPiSearchUtils {
    private static final Set<String> VALID_SEARCH_KEYS = new ImmutableSet.Builder().add((Object[])new String[]{"name", "summary"}).build();
    private static final String METHOD_NAME_EXPRESSION = "/methodCall/methodName/text()";
    private static final String SEARCH_OPERATOR_EXPRESSION = "/methodCall/params/param/value/string/text()";
    private static final String MEMBER_LIST_EXPRESSION = "/methodCall/params/param/value/struct/member";
    private static final String PARAMETER_NAME_EXPRESSION = "name/text()";
    private static final String PARAMETER_VALUE_EXPRESSION = "value/array/data/value/string/text()";

    static QueryBuilder parseSearchRequest(String repository, InputStream in) throws Exception {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)in);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", false);
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        Document document = builder.parse(in);
        String methodName = (String)xPath.evaluate(METHOD_NAME_EXPRESSION, document, XPathConstants.STRING);
        if (!"search".equals(methodName)) {
            throw new UnsupportedOperationException("Only search methods supported, found: " + methodName);
        }
        String searchOperator = (String)xPath.evaluate(SEARCH_OPERATOR_EXPRESSION, document, XPathConstants.STRING);
        if (!"or".equals(searchOperator)) {
            throw new UnsupportedOperationException("Only or-search operations supported, found: " + searchOperator);
        }
        BoolQueryBuilder query = QueryBuilders.boolQuery();
        NodeList members = (NodeList)xPath.evaluate(MEMBER_LIST_EXPRESSION, document, XPathConstants.NODESET);
        int index = 0;
        int count = members.getLength();
        while (index < count) {
            Node item = members.item(index);
            String name = (String)xPath.evaluate(PARAMETER_NAME_EXPRESSION, item, XPathConstants.STRING);
            if (!VALID_SEARCH_KEYS.contains(name)) {
                throw new UnsupportedOperationException("Search key not supported, found: " + name);
            }
            PyPiSearchUtils.addSubqueries(xPath, query, name, item);
            ++index;
        }
        query.minimumNumberShouldMatch(1);
        query.filter((QueryBuilder)QueryBuilders.termQuery((String)"repository_name", (String)repository));
        return query;
    }

    private static void addSubqueries(XPath xPath, BoolQueryBuilder query, String name, Node item) throws XPathExpressionException {
        Preconditions.checkNotNull((Object)xPath);
        Preconditions.checkNotNull((Object)query);
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)item);
        String parameterName = "attributes.pypi." + name;
        NodeList values = (NodeList)xPath.evaluate(PARAMETER_VALUE_EXPRESSION, item, XPathConstants.NODESET);
        int index = 0;
        int count = values.getLength();
        while (index < count) {
            Node value = values.item(index);
            String parameterValue = value.getTextContent().toLowerCase(Locale.ENGLISH);
            if (!parameterValue.contains("*")) {
                parameterValue = "*" + parameterValue + "*";
            }
            query.should((QueryBuilder)QueryBuilders.wildcardQuery((String)parameterName, (String)parameterValue));
            ++index;
        }
    }

    static String buildSearchResponse(Collection<PyPiSearchResult> results) throws Exception {
        Preconditions.checkNotNull(results);
        StringWriter s = new StringWriter();
        XMLOutputFactory factory = XMLOutputFactory.newInstance();
        Throwable throwable = null;
        Object var4_5 = null;
        try (SearchResponseWriter writer = new SearchResponseWriter(factory.createXMLStreamWriter(s));){
            writer.writePrologue();
            for (PyPiSearchResult result : results) {
                writer.writeEntry(result);
            }
            writer.writeEpilogue();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return s.toString();
    }

    static List<PyPiSearchResult> parseSearchResponse(InputStream in) throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(false);
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", false);
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        SearchResponseHandler handler = new SearchResponseHandler();
        SAXParser parser = factory.newSAXParser();
        parser.parse(in, (DefaultHandler)handler);
        return handler.getResults();
    }

    private PyPiSearchUtils() {
    }

    private static class SearchResponseHandler
    extends DefaultHandler {
        private List<PyPiSearchResult> results = new ArrayList<PyPiSearchResult>();
        private String currentName = null;
        private String currentVersion = null;
        private String currentSummary = null;
        private String currentMemberName = null;
        private String currentMemberValue = null;
        private StringBuilder currentCharacters = null;
        private boolean fault = false;

        private SearchResponseHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (this.fault) {
                return;
            }
            switch (qName) {
                case "fault": {
                    this.fault = true;
                    break;
                }
                case "member": {
                    this.currentMemberName = null;
                    this.currentMemberValue = null;
                    break;
                }
                case "name": {
                    this.currentCharacters = new StringBuilder();
                    break;
                }
                case "string": {
                    this.currentCharacters = new StringBuilder();
                    break;
                }
                case "boolean": {
                    this.currentCharacters = new StringBuilder();
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.fault) {
                return;
            }
            switch (qName) {
                case "struct": {
                    this.results.add(this.buildSearchResult());
                    this.currentName = null;
                    this.currentVersion = null;
                    this.currentSummary = null;
                    break;
                }
                case "member": {
                    this.store(this.currentMemberName, this.currentMemberValue);
                    this.currentMemberName = null;
                    this.currentMemberValue = null;
                    break;
                }
                case "name": {
                    this.currentMemberName = this.currentCharacters.toString();
                    this.currentCharacters = null;
                    break;
                }
                case "string": {
                    this.currentMemberValue = this.currentCharacters.toString();
                    this.currentCharacters = null;
                    break;
                }
                case "boolean": {
                    this.currentMemberValue = this.currentCharacters.toString();
                    this.currentCharacters = null;
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (!this.fault && this.currentCharacters != null) {
                this.currentCharacters.append(ch, start, length);
            }
        }

        private void store(String name, String value) {
            switch (name) {
                case "name": {
                    this.currentName = value;
                    break;
                }
                case "version": {
                    this.currentVersion = value;
                    break;
                }
                case "summary": {
                    this.currentSummary = value;
                }
            }
        }

        private PyPiSearchResult buildSearchResult() {
            return new PyPiSearchResult(Strings.nullToEmpty((String)this.currentName), Strings.nullToEmpty((String)this.currentVersion), Strings.nullToEmpty((String)this.currentSummary));
        }

        public List<PyPiSearchResult> getResults() {
            return this.results;
        }
    }
}

