/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.pypi.internal;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.group.GroupFacet;
import org.sonatype.nexus.repository.group.GroupHandler;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.pypi.internal.PyPiSearchResult;
import org.sonatype.nexus.repository.pypi.internal.PyPiSearchUtils;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.ViewUtils;
import org.sonatype.nexus.repository.view.payloads.BytesPayload;
import org.sonatype.nexus.repository.view.payloads.StringPayload;

@Named
@Singleton
class SearchGroupHandler
extends GroupHandler {
    SearchGroupHandler() {
    }

    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        Preconditions.checkNotNull((Object)context);
        String method = context.getRequest().getAction();
        if ("POST".equals(method)) {
            GroupHandler.DispatchedRepositories dispatched = (GroupHandler.DispatchedRepositories)context.getRequest().getAttributes().getOrCreate(GroupHandler.DispatchedRepositories.class);
            return this.doPost(context, dispatched);
        }
        return HttpResponses.methodNotAllowed((String)method, (String[])new String[]{"POST"});
    }

    protected Response doPost(@Nonnull Context context, @Nonnull GroupHandler.DispatchedRepositories dispatched) throws Exception {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)dispatched);
        Context replayableContext = this.buildReplayableContext(context);
        GroupFacet groupFacet = (GroupFacet)context.getRepository().facet(GroupFacet.class);
        LinkedHashMap<String, PyPiSearchResult> results = new LinkedHashMap<String, PyPiSearchResult>();
        for (Map.Entry entry : this.getAll(replayableContext, groupFacet.members(), dispatched).entrySet()) {
            Response response = (Response)entry.getValue();
            if (response.getStatus().getCode() != 200 || response.getPayload() == null) continue;
            this.processResponse(response, results);
        }
        String response = PyPiSearchUtils.buildSearchResponse(results.values());
        return HttpResponses.ok((Payload)new StringPayload(response, "text/html"));
    }

    private void processResponse(Response response, Map<String, PyPiSearchResult> results) throws Exception {
        Preconditions.checkNotNull((Object)response);
        Preconditions.checkNotNull(results);
        Payload payload = (Payload)Preconditions.checkNotNull((Object)response.getPayload());
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStream in = payload.openInputStream();){
            for (PyPiSearchResult result : PyPiSearchUtils.parseSearchResponse(in)) {
                String key = String.valueOf(result.getName()) + " " + result.getVersion();
                if (results.containsKey(key)) continue;
                results.put(key, result);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Context buildReplayableContext(Context context) throws IOException {
        Preconditions.checkNotNull((Object)context);
        Request request = (Request)Preconditions.checkNotNull((Object)context.getRequest());
        Payload payload = (Payload)Preconditions.checkNotNull((Object)request.getPayload());
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStream in = payload.openInputStream();){
            byte[] content = ByteStreams.toByteArray((InputStream)in);
            Context replayableContext = new Context(context.getRepository(), new Request.Builder().attributes(request.getAttributes()).headers(request.getHeaders()).action(request.getAction()).path(request.getPath()).parameters(request.getParameters()).payload((Payload)new BytesPayload(content, payload.getContentType())).build());
            ViewUtils.copyLocalContextAttributes((Context)context, (Context)replayableContext);
            return replayableContext;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

